/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.itbjfcl.dc.services.payment;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/FrontEnd/FrontEndServlet");
    }

    public int getBatchSize() {
        return 100;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.createRoot((String)"Iss_Itreasury");
        Element queryReq = JDomUtils.addChild((Element)root, (String)"QueryReq");
        JDomUtils.addChild((Element)queryReq, (String)"OperationType", (String)"2");
        JDomUtils.addChild((Element)queryReq, (String)"SystemID", (String)"ERP");
        JDomUtils.addChild((Element)queryReq, (String)"SendTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss SSS")));
        paymentInfos.forEach(paymentInfo -> {
            Element queryContent = JDomUtils.addChild((Element)queryReq, (String)"QueryContent");
            JDomUtils.addChild((Element)queryContent, (String)"ApplyCode", (String)paymentInfo.getBankDetailSeqID());
            JDomUtils.addChild((Element)queryContent, (String)"REVERSE1", (String)"");
            JDomUtils.addChild((Element)queryContent, (String)"REVERSE2", (String)"");
            JDomUtils.addChild((Element)queryContent, (String)"REVERSE3", (String)"");
            JDomUtils.addChild((Element)queryContent, (String)"REVERSE4", (String)"");
            JDomUtils.addChild((Element)queryContent, (String)"REVERSE5", (String)"");
        });
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element queryRen = JDomUtils.getChildElement((Element)root, (String)"QueryRen");
        String processCode = JDomUtils.getChildText((Element)queryRen, (String)"ProcessCode");
        String processDesc = JDomUtils.getChildText((Element)queryRen, (String)"ProcessDesc");
        List elements = queryRen.getChildren("RenContent");
        for (Element renContent : elements) {
            String applyCode = JDomUtils.getChildText((Element)renContent, (String)"ApplyCode");
            String businessCode = JDomUtils.getChildText((Element)renContent, (String)"BusinessCode");
            String businessDesc = JDomUtils.getChildText((Element)renContent, (String)"BusinessDesc");
            String instructionStatusCode = JDomUtils.getChildText((Element)renContent, (String)"InstructionStatusCode");
            String instructionStatusDesc = JDomUtils.getChildText((Element)renContent, (String)"InstructionStatusDesc");
            String reverse1 = JDomUtils.getChildText((Element)renContent, (String)"REVERSE1");
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)applyCode);
            if (paymentInfo == null) continue;
            paymentInfo.setReversed1(reverse1);
            if ("0".equalsIgnoreCase(instructionStatusCode)) {
                if ("0000".equalsIgnoreCase(businessCode) || "0001".equalsIgnoreCase(businessCode) || "0002".equalsIgnoreCase(businessCode) || "0004".equalsIgnoreCase(businessCode) || "0005".equalsIgnoreCase(businessCode)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-itbjfcl-dc", (Object[])new Object[0]), (String)businessCode, (String)businessDesc);
                    continue;
                }
                if ("0003".equalsIgnoreCase(businessCode) || "0006".equalsIgnoreCase(businessCode) || "0008".equalsIgnoreCase(businessCode) || "0009".equalsIgnoreCase(businessCode) || "0010".equalsIgnoreCase(businessCode) || "9001".equalsIgnoreCase(businessCode) || "9999".equalsIgnoreCase(businessCode)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-itbjfcl-dc", (Object[])new Object[0]), (String)businessCode, (String)businessDesc);
                    continue;
                }
                if ("0007".equalsIgnoreCase(businessCode)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-itbjfcl-dc", (Object[])new Object[0]), (String)businessCode, (String)businessDesc);
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-itbjfcl-dc", (Object[])new Object[0]), (String)businessCode, (String)businessDesc);
                continue;
            }
            if ("1".equalsIgnoreCase(instructionStatusCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-itbjfcl-dc", (Object[])new Object[0]), (String)instructionStatusCode, (String)instructionStatusDesc);
                continue;
            }
            if ("3".equalsIgnoreCase(instructionStatusCode) || "4".equalsIgnoreCase(instructionStatusCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-itbjfcl-dc", (Object[])new Object[0]), (String)instructionStatusCode, (String)instructionStatusDesc);
                continue;
            }
            if ("5".equalsIgnoreCase(instructionStatusCode) || "6".equalsIgnoreCase(instructionStatusCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-itbjfcl-dc", (Object[])new Object[0]), (String)instructionStatusCode, (String)instructionStatusDesc);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-itbjfcl-dc", (Object[])new Object[0]), (String)instructionStatusCode, (String)instructionStatusDesc);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

