/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gyb.dc.payment;

import java.time.ZoneOffset;
import java.util.Date;
import kd.ebg.aqap.banks.gyb.dc.helper.GYB_Packer;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public final class QueryPayPacker {
    private static final String TRANCODE = "B2eQueryTransferResult4UTF8";

    public String packQueryPay(PaymentInfo[] paymentInfos) {
        Element ebank_root = new Element("transaction");
        JDomUtils.addChild((Element)ebank_root, (Element)GYB_Packer.buildHead(TRANCODE, Sequence.genSequence()));
        Element RequestBody = new Element("RequestBody");
        Element body = JDomUtils.addChild((Element)RequestBody, (String)"RequestRecord");
        JDomUtils.addChild((Element)body, (String)"EbankSeqNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"batchID", (String)paymentInfos[0].getBankDetailSeqID());
        String time = DateUtil.formatDate((Date)Date.from(paymentInfos[0].getSubmitSuccessTime().atZone(ZoneOffset.ofHours(8)).toInstant()));
        JDomUtils.addChild((Element)body, (String)"TransDate", (String)time);
        JDomUtils.addChild((Element)ebank_root, (Element)RequestBody);
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2String((Element)ebank_root, (String)encoding);
        return requestMessage;
    }
}

