/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gyb.dc.payment.otherbank.superBank;

import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gyb.dc.payment.otherbank.superBank.TransferOtherBankPacker;
import kd.ebg.aqap.banks.gyb.dc.payment.otherbank.superBank.TransferOtherBankParser;
import kd.ebg.aqap.banks.gyb.dc.payment.otherbank.superBank.TransferOtherBankQueryImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;

public class TransferOtherBankImpl
extends AbstractPayImpl
implements IPay {
    public EBBankPayResponse doBiz(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        try {
            String rsqt = this.packPay(paymentInfos);
            String s = "/New_B2E/Forward.do?SIGDATA=1&";
            s = s + "userPassword=" + RequestContextUtils.getParameter().getBankParameter("userCif");
            ConnectionFactory factory = this.getConnectionFactory();
            factory.setUri(s);
            factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
            IConnection conn = this.getConnection(factory);
            this.openConnection(conn);
            try (OutputStream os = this.getOutputStream(conn);){
                this.send(os, rsqt);
                try (InputStream is = this.getInputStream(conn);){
                    String rsp = this.recv(is);
                    new TransferOtherBankParser().parsePay(paymentInfos, rsp);
                }
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    private String packPay(PaymentInfo[] paymentInfos) {
        return new TransferOtherBankPacker().packPay(paymentInfos);
    }

    public String getDeveloper() {
        return "simon_wx";
    }

    public String getBizCode() {
        return "B2eSuperTransfer4UTF8";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d85\u7ea7\u7f51\u94f6\u8f6c\u8d26", (String)"TransferOtherBankImpl_0", (String)"ebg-aqap-banks-gyb-dc", (Object[])new Object[0]);
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return TransferOtherBankQueryImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

