/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_BankBatchSeqIdCreator;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Packer;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt bankAcnt = bankBalanceRequest.getAcnt();
        Element root = BOCHK_DC_Packer.createRootWithHead(BOCHK_DC_BankBatchSeqIdCreator.getPackageId());
        Element Tx = JDomUtils.createRoot((String)"Tx");
        Element AcctBalanceREQ = JDomUtils.addChild((Element)Tx, (String)"AcctBalanceREQ");
        JDomUtils.addChild((Element)AcctBalanceREQ, (String)"AcctNo", (String)bankAcnt.getAccNo());
        JDomUtils.addChild((Element)root, (Element)Tx);
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2String((Element)root, (String)encoding);
        log.info("\u67e5\u8be2\u4f59\u989d\u62a5\u6587\u5982\u4e0b\uff1a" + requestMessage);
        return requestMessage;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        EBBankBalanceResponse bankBalanceResponse = null;
        log.info("==\u67e5\u8be2\u4f59\u989d\u54cd\u5e94\u62a5\u6587\u7684\u89e3\u6790\u2014\u2014\u5f00\u59cb==");
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankRsp = BOCHK_DC_Parser.parseHead(root);
        if (!"S".equals(bankRsp.getResponseCode())) {
            String ErrorCode = root.getChild("Head").getChild("ErrorCode").getTextTrim();
            String ErrorDesc = root.getChild("Head").getChild("ErrorDesc").getTextTrim();
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u4e3a(%1$s,%2$S);\u9519\u8bef\u7801\uff1a%3$S,\u9519\u8bef\u8bf4\u660e\uff1a%4$S", (String)"BalanceImpl_11", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), bankRsp.getResponseCode(), bankRsp.getResponseMessage(), ErrorCode, ErrorDesc));
        }
        Element AcctBalanceRLY = root.getChild("Tx").getChild("AcctBalanceRLY");
        String AcctNo = AcctBalanceRLY.getChild("AcctNo").getTextTrim();
        if (!request.getAcnt().getAccNo().equals(AcctNo)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8d26\u53f7(%1$s)\u4e0e\u8fd4\u56de\u8d26\u53f7(%2$s)\u4e0d\u4e00\u81f4\uff1b", (String)"BalanceImpl_12", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), request.getAcnt().getAccNo(), AcctNo));
        }
        String LastUpdateTime = AcctBalanceRLY.getChildTextTrim("LastUpdateTime");
        LocalDateTime balanceTime = this.parseBalanceTime(LastUpdateTime);
        List elementList = AcctBalanceRLY.getChild("AcctInfo").getChildren();
        Element element = (Element)elementList.get(0);
        if ("SavingAcct".equalsIgnoreCase(element.getName())) {
            bankBalanceResponse = this.getSavingBalance(request, root.getChild("Tx"), balanceTime);
        } else if ("CurrentAcct".equalsIgnoreCase(element.getName())) {
            bankBalanceResponse = this.getCurrentBalance(request, root.getChild("Tx"), balanceTime);
        } else if ("MTCSavingAcct".equalsIgnoreCase(element.getName())) {
            bankBalanceResponse = this.getMTCSavingBalance(request, root.getChild("Tx"), balanceTime);
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u9519\u8bef\u7684\u4f59\u989d\u67e5\u8be2\u54cd\u5e94\u62a5\u6587\uff08\u54cd\u5e94\u62a5\u6587\u4e2d\u6ca1\u6709\u5132\u84c4\u6236\u53e3/\u652f\u7968\u6236\u53e3/\u5916\u532f\u5bf6 \u7684\u8282\u70b9\u4fe1\u606f\uff09\u3002", (String)"BalanceImpl_6", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]));
        }
        log.info("==\u67e5\u8be2\u4f59\u989d\u54cd\u5e94\u62a5\u6587\u7684\u89e3\u6790\u2014\u2014\u7ed3\u675f==");
        return bankBalanceResponse;
    }

    private EBBankBalanceResponse getSavingBalance(BankBalanceRequest rqst, Element Tx, LocalDateTime balanceTime) {
        log.info("\u89e3\u6790\u67e5\u8be2\u4f59\u989d\u62a5\u6587--\u5132\u84c4\u6236\u53e3");
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        BalanceInfo balanceInfo = new BalanceInfo();
        Element SavingAcct = Tx.getChild("AcctBalanceRLY").getChild("AcctInfo").getChild("SavingAcct");
        String Cur = SavingAcct.getChildTextTrim("Cur");
        String AcctBalance = SavingAcct.getChildTextTrim("AcctBalance");
        String AvailBalance = SavingAcct.getChildTextTrim("AvailBalance");
        this.setBankAcnt(balanceInfo, rqst.getAcnt());
        this.setBankCurrency(balanceInfo, Cur);
        this.setCurrentBalance(balanceInfo, AcctBalance);
        this.setAvailableBalance(balanceInfo, AvailBalance);
        this.setBalanceDateTime(balanceInfo, balanceTime);
        bankBalanceResponse.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
        return bankBalanceResponse;
    }

    private EBBankBalanceResponse getCurrentBalance(BankBalanceRequest rqst, Element Tx, LocalDateTime balanceTime) {
        log.info("\u89e3\u6790\u67e5\u8be2\u4f59\u989d\u62a5\u6587--\u652f\u7968\u6236\u53e3");
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        BalanceInfo balanceInfo = new BalanceInfo();
        Element CurrentAcct = Tx.getChild("AcctBalanceRLY").getChild("AcctInfo").getChild("CurrentAcct");
        String Cur = CurrentAcct.getChildTextTrim("Cur");
        String LedgerBalance = CurrentAcct.getChildTextTrim("LedgerBalance");
        String AvailBalance = CurrentAcct.getChildTextTrim("AvailBalance");
        this.setBankAcnt(balanceInfo, rqst.getAcnt());
        this.setBankCurrency(balanceInfo, Cur);
        this.setCurrentBalance(balanceInfo, LedgerBalance);
        this.setAvailableBalance(balanceInfo, AvailBalance);
        this.setBalanceDateTime(balanceInfo, balanceTime);
        bankBalanceResponse.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
        return bankBalanceResponse;
    }

    private EBBankBalanceResponse getMTCSavingBalance(BankBalanceRequest rqst, Element Tx, LocalDateTime balanceTime) {
        log.info("\u89e3\u6790\u67e5\u8be2\u4f59\u989d\u62a5\u6587--\u5916\u532f\u5bf6");
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        Element MTCSavingAcct = Tx.getChild("AcctBalanceRLY").getChild("AcctInfo").getChild("MTCSavingAcct");
        List records = MTCSavingAcct.getChild("Result").getChildren("Record");
        BalanceInfo balanceInfo = null;
        int length = records.size();
        for (int i = 0; i < length; ++i) {
            Element Record = (Element)records.get(i);
            String Cur = Record.getChildTextTrim("Cur");
            if (!Cur.equals(rqst.getBankCurrency())) continue;
            String AcctBalance = Record.getChildTextTrim("AcctBalance");
            String AvailBalance = Record.getChildTextTrim("AvailBalance");
            balanceInfo = new BalanceInfo();
            this.setBankAcnt(balanceInfo, rqst.getAcnt());
            this.setBankCurrency(balanceInfo, Cur);
            this.setCurrentBalance(balanceInfo, AcctBalance);
            this.setAvailableBalance(balanceInfo, AvailBalance);
            this.setBalanceDateTime(balanceInfo, balanceTime);
        }
        if (balanceInfo == null) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5931\u8d25\uff0c\u94f6\u884c\u672a\u8fd4\u56de\u8bf7\u6c42\u8d26\u53f7[%1$s]\u6240\u67e5\u8be2\u5e01\u79cd[%2$s]\u7684\u4f59\u989d\u4fe1\u606f\u3002", (String)"BalanceImpl_13", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), rqst.getAcnt().getAccNo(), rqst.getBankCurrency()));
        }
        bankBalanceResponse.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
        return bankBalanceResponse;
    }

    private LocalDateTime parseBalanceTime(String LastUpdateTime) {
        LocalDateTime balanceTime = LocalDateTime.parse(LastUpdateTime, DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss"));
        return balanceTime;
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "AcctBalanceREQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u672c\u884c\u8d26\u6237\u4f59\u989d", (String)"BalanceImpl_10", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]);
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"bankUrl"));
        factory.setHttpHeader("Content-Type", "application/xml;charset=" + RequestContextUtils.getCharset());
        return factory;
    }

    public boolean match(BankBalanceRequest request) {
        return !BankBusinessConfig.getBOC_HK_OTHER_OR_SELF_QRY();
    }
}

