/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.payment.TeleTransfer;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.BOCHK_DC_Constants;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Packer;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Parser;
import kd.ebg.aqap.banks.bochk.dc.services.payment.TeleTransfer.TeleTransferQryPayImpl;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccess;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccessManager;
import kd.ebg.aqap.banks.bochk.dc.utils.MultiLinesUtils;
import kd.ebg.aqap.banks.bochk.dc.utils.TransactionRemarksUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TeleTransferPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 50;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return TeleTransferQryPayImpl.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public String pack(BankPayRequest bankPayRequest) {
        PayLoginAccess la = PayLoginAccessManager.searchLock();
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo1 = (PaymentInfo)paymentInfos.get(0);
        try {
            la.getToken();
            Element root = BOCHK_DC_Packer.createRootWithHead(paymentInfo1.getPackageId());
            PaymentInfoSysFiled.set((List)paymentInfos, (String)"BOCHK_PACKAGEID", (String)paymentInfo1.getPackageId());
            Element tx = new Element("Tx");
            Element transferReq = JDomUtils.addChild((Element)tx, (String)"TransferREQ");
            JDomUtils.addChild((Element)transferReq, (String)"DebitAcctNo", (String)paymentInfo1.getAccNo());
            JDomUtils.addChild((Element)transferReq, (String)"DebitCur", (String)paymentInfo1.getCurrency());
            Element requests = new Element("Requests");
            int num = paymentInfos.size();
            requests.setAttribute("noOfRecord", Integer.toString(num));
            for (PaymentInfo paymentInfo : paymentInfos) {
                void var21_23;
                String ctry;
                boolean isNeedCnapNo;
                Element record = new Element("Record");
                Element teletransfer = new Element("TeleTransfer");
                JDomUtils.addChild((Element)record, (Element)teletransfer);
                JDomUtils.addChild((Element)requests, (Element)record);
                JDomUtils.addChild((Element)teletransfer, (String)"RemitCur", (String)paymentInfo.getPayCurrency());
                JDomUtils.addChild((Element)teletransfer, (String)"RemitAmt", (String)paymentInfo.getActualAmount().setScale(2).toString());
                Element chargeFrom = JDomUtils.addChild((Element)teletransfer, (String)"ChargeFrom");
                if ("02".equals(paymentInfo.getPayerFeeType())) {
                    JDomUtils.addChild((Element)chargeFrom, (String)"ChargeFromBene");
                } else {
                    Element chargeFromAcct = JDomUtils.addChild((Element)chargeFrom, (String)"ChargeFromAcct");
                    JDomUtils.addChild((Element)chargeFromAcct, (String)"ChargeAcctNo", (String)paymentInfo.getPayerFeeAccNo());
                    JDomUtils.addChild((Element)chargeFromAcct, (String)"ChargeCur", (String)paymentInfo.getPayerFeeCurrency());
                    if ("01".equals(paymentInfo.getPayerFeeType())) {
                        JDomUtils.addChild((Element)chargeFromAcct, (String)"ChargeBorneBy", (String)"A");
                    } else if ("03".equals(paymentInfo.getPayerFeeType())) {
                        JDomUtils.addChild((Element)chargeFromAcct, (String)"ChargeBorneBy", (String)"B");
                    }
                }
                if (StringUtils.isEmpty((String)paymentInfo.getIncomeSwiftCode())) {
                    JDomUtils.addChild((Element)teletransfer, (String)"BeneBankerSwiftCode", (String)"");
                    isNeedCnapNo = !StringUtils.isEmpty((String)paymentInfo.getIncomeCnaps());
                } else {
                    JDomUtils.addChild((Element)teletransfer, (String)"BeneBankerSwiftCode", (String)paymentInfo.getIncomeSwiftCode());
                    isNeedCnapNo = false;
                }
                CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getIncomeCountry());
                if (null == code) {
                    code = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getIncomeCountry());
                }
                if ("CT".equals(ctry = code.geteChart2())) {
                    ctry = "TW";
                }
                JDomUtils.addChild((Element)teletransfer, (String)"BeneBankerCountry", (String)ctry);
                Element benebankername = JDomUtils.addChild((Element)teletransfer, (String)"BeneBankerName");
                if (StringUtils.isEmpty((String)paymentInfo.getIncomeSwiftCode()) && !isNeedCnapNo) {
                    List<String> incomeBankAddress = MultiLinesUtils.build(paymentInfo.getIncomeBankName() + paymentInfo.getIncomeBankAddress(), 3);
                    for (String string : incomeBankAddress) {
                        JDomUtils.addChild((Element)benebankername, (String)"Line", (String)string);
                    }
                } else {
                    JDomUtils.addChild((Element)benebankername, (String)"Line", (String)"");
                    JDomUtils.addChild((Element)benebankername, (String)"Line", (String)"");
                    JDomUtils.addChild((Element)benebankername, (String)"Line", (String)"");
                }
                if ("CNY".equals(paymentInfo.getPayCurrency())) {
                    String transactionRemarks = TransactionRemarksUtils.getInstance().getTransactionRemark(paymentInfo.getTransactionRemarks(), paymentInfo.getBankVersionID());
                    if (StringUtils.isEmpty((String)transactionRemarks)) {
                        transactionRemarks = paymentInfo.getTransactionRemarks();
                    }
                    String cnaps = paymentInfo.getIncomeCnaps();
                    if (isNeedCnapNo) {
                        JDomUtils.addChild((Element)teletransfer, (String)"CnapsNum", (String)cnaps);
                    }
                    JDomUtils.addChild((Element)teletransfer, (String)"RMBRemitTxType", (String)transactionRemarks);
                }
                JDomUtils.addChild((Element)teletransfer, (String)"RemitBeneAcctNo", (String)paymentInfo.getIncomeAccNo());
                Element remitbenename = JDomUtils.addChild((Element)teletransfer, (String)"RemitBeneName");
                List<String> incomeAccNames = MultiLinesUtils.build(paymentInfo.getIncomeAccName(), 4);
                for (String line3 : incomeAccNames) {
                    JDomUtils.addChild((Element)remitbenename, (String)"Line", (String)line3);
                }
                JDomUtils.addChild((Element)teletransfer, (String)"BeneBankerAcct", (String)paymentInfo.getProxyAccNo());
                CountryISOCode countryISOCode = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getProxyBankCountry());
                if (null == countryISOCode) {
                    CountryISOCode countryISOCode2 = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getProxyBankCountry());
                }
                String proCtry = "";
                if (var21_23 != null && "CT".equals(proCtry = var21_23.geteChart2())) {
                    proCtry = "TW";
                }
                JDomUtils.addChild((Element)teletransfer, (String)"CorreBeneBankerCountry", (String)proCtry);
                JDomUtils.addChild((Element)teletransfer, (String)"CorreBeneBankerSwiftCode", (String)paymentInfo.getProxyBankSwiftCode());
                Element correbenebanker = JDomUtils.addChild((Element)teletransfer, (String)"CorreBeneBanker");
                if (StringUtils.isEmpty((String)paymentInfo.getProxyAccName())) {
                    JDomUtils.addChild((Element)correbenebanker, (String)"Line", (String)"");
                    JDomUtils.addChild((Element)correbenebanker, (String)"Line", (String)"");
                    JDomUtils.addChild((Element)correbenebanker, (String)"Line", (String)"");
                } else {
                    List<String> proxyInfos = MultiLinesUtils.build(paymentInfo.getProxyAccName() + paymentInfo.getProxyBankAddress(), 3);
                    for (String string : proxyInfos) {
                        JDomUtils.addChild((Element)correbenebanker, (String)"Line", (String)string);
                    }
                }
                Element paymentdetail = JDomUtils.addChild((Element)teletransfer, (String)"PaymentDetail");
                List<String> explanations = MultiLinesUtils.build(paymentInfo.getExplanation(), 4);
                for (String line5 : explanations) {
                    JDomUtils.addChild((Element)paymentdetail, (String)"Line", (String)line5);
                }
                String string = paymentInfo.getReversed4();
                if (!StringUtils.isEmpty((String)string)) {
                    int index = string.indexOf("BOCHKM2B=");
                    if (-1 != index) {
                        String mesage2bank = string.substring(9, string.length());
                        JDomUtils.addChild((Element)teletransfer, (String)"MessageToBank", (String)mesage2bank);
                    } else {
                        JDomUtils.addChild((Element)teletransfer, (String)"MessageToBank", (String)"");
                    }
                } else {
                    JDomUtils.addChild((Element)teletransfer, (String)"MessageToBank", (String)"");
                }
                JDomUtils.addChild((Element)teletransfer, (String)"CustRef", (String)paymentInfo.getBankDetailSeqId());
                JDomUtils.addChild((Element)teletransfer, (String)"ExContract", (String)paymentInfo.getExContract());
                JDomUtils.addChild((Element)teletransfer, (String)"ValueDate", (String)BOCHK_DC_Packer.valueDate(paymentInfo.getBookingTime()));
                PaymentUtil.setBookPayFlag((PaymentInfo)paymentInfo);
            }
            JDomUtils.addChild((Element)transferReq, (Element)requests);
            JDomUtils.addChild((Element)root, (Element)tx);
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u91ca\u653e\u8bbf\u95ee\u7968", (String)"TeleTransferPayImpl_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BOCHK_DC_Parser.overseaParsePay(paymentInfos, s, "FasterPayment");
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "OvrsTransREQ-TeleTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"6.2.20\u6d77\u5916\u9280\u884c\u96fb\u532f(OvrsTransREQ-TeleTransfer)", (String)"TeleTransferPayImpl_1", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return StringUtils.isNotEmpty((String)paymentInfo.getUseCN()) && BOCHK_DC_Constants.getTELE_TRANSFER().equalsIgnoreCase(paymentInfo.getUseCN().trim());
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"bankUrl"));
        factory.setHttpHeader("Content-Type", "application/xml;charset=" + RequestContextUtils.getCharset());
        return factory;
    }
}

