/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.payment.ticket;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayLoginAccess {
    private static Logger logger = LoggerFactory.getLogger(PayLoginAccess.class);
    private long interval = 30000L;
    private String key;
    private boolean inUse;

    public PayLoginAccess(String key) {
        this.key = key;
        logger.info(key + ":" + this.interval + "(ms).");
    }

    public String getKey() {
        return this.key;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public synchronized void getToken() {
        String threadName = this.getCurrThreadName();
        logger.info(threadName + " \u8bd5\u56fe\u83b7\u53d6\u8bbf\u95ee\u7968");
        while (this.inUse) {
            logger.info(threadName + " \u8bbf\u95ee\u7968\u4e0d\u53ef\u7528,\u7b49\u5f85");
            try {
                this.wait();
            }
            catch (Exception t) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)" \u83b7\u53d6\u8bbf\u95ee\u7968wait\u5f02\u5e38\u3002", (String)"PayLoginAccess_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (Throwable)t);
            }
        }
        logger.info(threadName + " \u83b7\u53d6\u8bbf\u95ee\u7968");
        this.inUse = true;
        this.notifyAll();
    }

    public synchronized void availableRelease() {
        String threadName = this.getCurrThreadName();
        logger.info(threadName + " \u6b63\u5728\u91ca\u653e\u8bbf\u95ee\u7968...");
        this.sleepQuietly(this.interval);
        this.inUse = false;
        logger.info(threadName + " \u8bbf\u95ee\u7968\u5df2\u91ca\u653e");
        this.notifyAll();
    }

    public synchronized void unavailableRelease() {
        String threadName = this.getCurrThreadName();
        logger.info(threadName + " \u6b63\u5728\u91ca\u653e\u8bbf\u95ee\u7968...");
        this.sleepQuietly(this.interval);
        this.inUse = false;
        logger.info(threadName + " \u8bbf\u95ee\u7968\u5df2\u91ca\u653e");
        this.notifyAll();
    }

    private void sleepQuietly(long time) {
        try {
            if (EBContext.getContext().isUnitTest()) {
                return;
            }
            Thread.currentThread();
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getCurrThreadName() {
        String name = "";
        try {
            name = Thread.currentThread().getName();
        }
        catch (Exception localException) {
            throw EBExceiptionUtil.serviceException((Throwable)localException);
        }
        return name;
    }
}

