/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsb.dc.service.payment.individual.salary;

import java.math.BigDecimal;
import java.util.List;
import kd.ebg.aqap.banks.hsb.dc.HSBUtils;
import kd.ebg.aqap.banks.hsb.dc.HSB_DC_Packer;
import kd.ebg.aqap.banks.hsb.dc.service.proxy.FileUpload;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    private static final String BATCHFILEHEDAER = "ACNO|CUR_CODE|ACNAME|CARDFLAG|AMT|POSTSCRIPT|";
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(PayPacker.class);

    public static String packPay(List<PaymentInfo> paymentInfos) throws EBServiceException {
        PaymentInfo paymentInfo = paymentInfos.get(0);
        Element root = HSB_DC_Packer.buildHead("300002", Sequence.genSequence(), true);
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"as_acno", (String)"");
        JDomUtils.addChild((Element)body, (String)"as_acname", (String)"");
        JDomUtils.addChild((Element)body, (String)"supply_item", (String)HSBUtils.getHsbUseCode(paymentInfo.getUseCn()));
        BigDecimal totalAmt = new BigDecimal("0.00");
        Element totalAmtElement = JDomUtils.addChild((Element)body, (String)"amt");
        JDomUtils.addChild((Element)body, (String)"count", (String)String.valueOf(paymentInfos.size()));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)paymentInfo.getExplanation());
        String fileName = paymentInfo.getPackageId() + ".txt";
        JDomUtils.addChild((Element)body, (String)"file_name", (String)fileName);
        JDomUtils.addChild((Element)body, (String)"field_num", (String)"6");
        JDomUtils.addChild((Element)body, (String)"record_num", (String)(paymentInfos.size() + ""));
        StringBuilder fileTextBuffer = new StringBuilder();
        fileTextBuffer.append(BATCHFILEHEDAER);
        fileTextBuffer.append("\r\n");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            paymentInfo = paymentInfos.get(i);
            totalAmt = totalAmt.add(paymentInfo.getAmount());
            fileTextBuffer.append(paymentInfo.getIncomeAccNo()).append("|");
            fileTextBuffer.append(paymentInfo.getCurrency()).append("|");
            fileTextBuffer.append(paymentInfo.getIncomeAccName()).append("|");
            fileTextBuffer.append("0").append("|");
            fileTextBuffer.append(paymentInfo.getAmount().setScale(2, 1).toString()).append("|");
            fileTextBuffer.append(paymentInfo.getExplanation()).append("|");
            if (i >= paymentInfos.size() - 1) continue;
            fileTextBuffer.append("\r\n");
        }
        totalAmtElement.setText(totalAmt.setScale(2, 1).toString());
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        FileUpload fileUpLoad = new FileUpload();
        fileUpLoad.setFileContent(fileTextBuffer.toString());
        fileUpLoad.doBiz(fileName);
        return HSB_DC_Packer.buildCommonMsg(xmlStr);
    }
}

