/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citi.dc.services.payment.cbft;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citi.dc.CitiMetaDataImpl;
import kd.ebg.aqap.banks.citi.dc.services.payment.CITI_DC_CommonPacker;
import kd.ebg.aqap.banks.citi.dc.services.payment.querypay.QueryPayImpl;
import kd.ebg.aqap.banks.citi.dc.utils.Helper;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.aqap.proxy.oversea.bank.AbstractOverseaPayImpl;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PayImpl
extends AbstractOverseaPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getPayFileName(BankPayRequest request) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        String prefix = RequestContextUtils.getBankParameterValue((String)CitiMetaDataImpl.pay_file_name);
        String fileName = StringUtils.isNotEmpty((String)prefix) ? prefix + "_" + paymentInfo.getBankBatchSeqID() + ".xml" : paymentInfo.getBankBatchSeqID() + ".xml";
        this.logger.info("\u4ed8\u6b3e\u6587\u4ef6\u540dfileName:" + fileName);
        return fileName;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.createRoot((String)"Document");
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Namespace ns2 = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        root.setNamespace(ns1);
        root.addNamespaceDeclaration(ns2);
        Element CstmrCdtTrfInitn = JDomUtils.addChild((Element)root, (String)"CstmrCdtTrfInitn").setNamespace(ns1);
        Element GrpHdr = CITI_DC_CommonPacker.packPayXmlhead(paymentInfos, CstmrCdtTrfInitn, ns1);
        Element PmtInf = CITI_DC_CommonPacker.packPayXmlPmtInfo(paymentInfos, CstmrCdtTrfInitn);
        BigDecimal totalAmount = new BigDecimal("0.00");
        Helper helper = new Helper();
        for (PaymentInfo info : paymentInfos) {
            String exp;
            Element CdtTrfTxInf = JDomUtils.addChild((Element)PmtInf, (String)"CdtTrfTxInf").setNamespace(ns1);
            Element PmtId = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"PmtId").setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"EndToEndId", (String)info.getBankDetailSeqId()).setNamespace(ns1);
            Element Amt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Amt").setNamespace(ns1);
            BigDecimal amount = info.getAmount();
            if ("overseaPay".equals(info.getSubBizType())) {
                amount = info.getActualAmount();
            }
            Element InstdAmt = JDomUtils.addChild((Element)Amt, (String)"InstdAmt", (String)amount.toString()).setNamespace(ns1);
            totalAmount = totalAmount.add(amount);
            String currency = info.getCurrency();
            if ("overseaPay".equals(info.getSubBizType())) {
                currency = info.getPayCurrency();
            }
            InstdAmt.setAttribute("Ccy", currency);
            if ("overseaPay".equals(info.getSubBizType())) {
                if (info.getPayerFeeType().equals("01")) {
                    JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"DEBT").setNamespace(ns1);
                } else if (info.getPayerFeeType().equals("02")) {
                    JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"CRED").setNamespace(ns1);
                } else if (info.getPayerFeeType().equals("03")) {
                    JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"SHAR").setNamespace(ns1);
                }
            } else if ("1".equals(info.getFeeType())) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"DEBT").setNamespace(ns1);
            } else if ("0".equals(info.getFeeType())) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"CRED").setNamespace(ns1);
            } else if ("2".equals(info.getFeeType())) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"SHAR").setNamespace(ns1);
            }
            String type = PaymentInfoSysFiled.get((PaymentInfo)info, (String)"proxyAccNoType");
            if (!StringUtils.isEmpty((String)type)) {
                CountryISOCode code;
                Element IntrmyAgt1 = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"IntrmyAgt1").setNamespace(ns1);
                Element FinInstnId = JDomUtils.addChild((Element)IntrmyAgt1, (String)"FinInstnId").setNamespace(ns1);
                JDomUtils.addChild((Element)FinInstnId, (String)"BIC", (String)info.getProxyBankSwiftCode()).setNamespace(ns1);
                if (!StringUtils.isEmpty((String)info.getProxyBankName())) {
                    JDomUtils.addChild((Element)FinInstnId, (String)"Nm", (String)info.getProxyBankName()).setNamespace(ns1);
                }
                if (null == (code = ISOCountryUtils.getInstance().getCountryInfo(info.getProxyBankCountry()))) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ee3\u7406\u884c\u56fd\u5bb6\u7801\uff1a%1$s\u683c\u5f0f\u4e0d\u5bf9\uff0c\u6216\u672a\u80fd\u4ece\u56fd\u5bb6\u4ee3\u7801\u8868\u4e2d\u5339\u914d\u3002", (String)"PayImpl_15", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), info.getProxyBankCountry()));
                }
                Element PstlAdr = JDomUtils.addChild((Element)FinInstnId, (String)"PstlAdr").setNamespace(ns1);
                JDomUtils.addChild((Element)PstlAdr, (String)"Ctry", (String)code.geteChart2()).setNamespace(ns1);
                if (!StringUtils.isEmpty((String)info.getProxyBankAddress())) {
                    JDomUtils.addChild((Element)PstlAdr, (String)"AdrLine", (String)info.getProxyBankAddress()).setNamespace(ns1);
                }
                Element IntrmyAgt1Acct = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"IntrmyAgt1Acct").setNamespace(ns1);
                Element Id = JDomUtils.addChild((Element)IntrmyAgt1Acct, (String)"Id").setNamespace(ns1);
                if ("IBAN".equals(type)) {
                    JDomUtils.addChild((Element)Id, (String)"IBAN", (String)info.getProxyAccNo()).setNamespace(ns1);
                } else if ("OTHR".equals(type)) {
                    Element OTHR = JDomUtils.addChild((Element)Id, (String)"Othr").setNamespace(ns1);
                    JDomUtils.addChild((Element)OTHR, (String)"Id", (String)info.getProxyAccNo()).setNamespace(ns1);
                } else {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u4ee3\u7406\u5e10\u53f7\u79cd\u7c7b\uff1a%1$s\u3002", (String)"PayImpl_16", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), type));
                }
            }
            Element CdtrAgt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAgt").setNamespace(ns1);
            Element CdtrAgt_FinInstnId = JDomUtils.addChild((Element)CdtrAgt, (String)"FinInstnId").setNamespace(ns1);
            if (!StringUtils.isEmpty((String)info.getIncomeSwiftCode())) {
                JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"BIC", (String)info.getIncomeSwiftCode()).setNamespace(ns1);
            }
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"Nm", (String)info.getIncomeBankName()).setNamespace(ns1);
            Element CdtrAgt_FinInstnId_PstlAdr = JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"PstlAdr").setNamespace(ns1);
            String benefitBankAddress = info.getIncomeBankAddress();
            helper.addressSplit(CdtrAgt_FinInstnId_PstlAdr, benefitBankAddress, ns1);
            CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfo(info.getIncomeCountry());
            if (null == code && null == (code = ISOCountryUtils.getInstance().getCountryInfoByName(info.getIncomeCountry()))) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6\uff1a%1$s \u683c\u5f0f\u4e0d\u5bf9\uff0c\u6216\u672a\u80fd\u4ece\u56fd\u5bb6\u4ee3\u7801\u8868\u4e2d\u5339\u914d\u3002", (String)"PayImpl_14", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), info.getIncomeCountry()));
            }
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId_PstlAdr, (String)"Ctry", (String)code.geteChart2()).setNamespace(ns1);
            Element Cdtr = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Cdtr").setNamespace(ns1);
            String name = info.getIncomeAccName();
            String ctry = code.geteChart2();
            Element Cdtr_PstlAdr = null;
            if ("HK".equals(ctry) && name.length() > 70) {
                JDomUtils.addChild((Element)Cdtr, (String)"Nm", (String)name.substring(0, 70)).setNamespace(ns1);
                Cdtr_PstlAdr = JDomUtils.addChild((Element)Cdtr, (String)"PstlAdr").setNamespace(ns1);
                JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"Adrline", (String)name.substring(70)).setNamespace(ns1);
            } else {
                JDomUtils.addChild((Element)Cdtr, (String)"Nm", (String)helper.formatStringByLength(name, 140)).setNamespace(ns1);
            }
            if (Cdtr_PstlAdr == null) {
                Cdtr_PstlAdr = JDomUtils.addChild((Element)Cdtr, (String)"PstlAdr").setNamespace(ns1);
            }
            helper.addressSplit(Cdtr_PstlAdr, info.getIncomeAddress(), ns1);
            JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"Ctry", (String)code.geteChart2()).setNamespace(ns1);
            Element CdtrAcct = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAcct").setNamespace(ns1);
            Element CdtrAcct_Id = JDomUtils.addChild((Element)CdtrAcct, (String)"Id").setNamespace(ns1);
            Element CdtrAcct_Id_Othr = JDomUtils.addChild((Element)CdtrAcct_Id, (String)"Othr").setNamespace(ns1);
            JDomUtils.addChild((Element)CdtrAcct_Id_Othr, (String)"Id", (String)info.getIncomeAccNo()).setNamespace(ns1);
            if ("US".equals(ctry)) {
                Element RgltryRptg = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RgltryRptg").setNamespace(ns1);
                Element Dtls = JDomUtils.addChild((Element)RgltryRptg, (String)"Dtls").setNamespace(ns1);
                Element Tp = JDomUtils.addChild((Element)Dtls, (String)"Tp").setNamespace(ns1);
                JDomUtils.addChild((Element)Tp, (String)"Cd", (String)"CACC").setNamespace(ns1);
            }
            if (StringUtils.isEmpty((String)(exp = info.getExplanation()))) continue;
            Element RmtInf = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RmtInf").setNamespace(ns1);
            List<String> list = Helper.getStrList(exp, 35);
            for (String string : list) {
                JDomUtils.addChild((Element)RmtInf, (String)"Ustrd", (String)string).setNamespace(ns1);
            }
        }
        Element CtrlSum = GrpHdr.getChild("CtrlSum", ns1);
        CtrlSum.addContent(totalAmount.toString());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBFT";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"CBFT(\u8de8\u5883\u6c47\u6b3e\u65b9\u5f0f CROSS BORDER FUND TRANSFER)", (String)"PayImpl_12", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return !paymentInfo.getBankVersionID().equalsIgnoreCase("SWIFT_DC") && "CBFT".equalsIgnoreCase(paymentInfo.getUseCN());
    }
}

