/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.shrcb.dc.utils;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.shrcb.dc.services.login.LoginImpl;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Parser {
    public static BankResponse parserMsgHead(Element root) throws EBServiceException {
        BankResponse response = new BankResponse();
        try {
            Element head = root.getChild("head");
            String respCode = head.getChildTextTrim("ret_code");
            String respMsg = head.getChildTextTrim("err_msg");
            response.setResponseCode(respCode);
            response.setResponseMessage(respMsg);
            if ("SE50000".equals(respCode)) {
                new LoginImpl().clearToken();
            }
        }
        catch (Exception e) {
            EBServiceException ex = EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u6d88\u606f\u5934\u5f02\u5e38 \u5f02\u5e38\u4fe1\u606f\uff1a%1$s\u3002", (String)"Parser_6", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            throw ex;
        }
        return response;
    }

    public static void parsePayRsp(List<PaymentInfo> paymentInfos, String rspStr) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parserMsgHead(root);
        PaymentInfo paymentInfo = paymentInfos.get(0);
        if ("SE50019".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"Parser_1", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        if (!"000000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"Parser_2", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        Element body = root.getChild("body");
        String pay_status = body.getChildTextTrim("pay_status");
        String bank_remark = body.getChildTextTrim("bank_remark");
        if ("4".equals(pay_status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"Parser_3", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]), (String)pay_status, (String)ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"Parser_4", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]));
        } else if ("5".equals(pay_status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"Parser_1", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]), (String)pay_status, (String)bank_remark);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"Parser_2", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]), (String)pay_status, (String)bank_remark);
        }
    }

    public static void parseQueryPayRsp(List<PaymentInfo> paymentInfos, String rspStr) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parserMsgHead(root);
        PaymentInfo paymentInfo = paymentInfos.get(0);
        if ("SE50019".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"Parser_1", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        if (!"000000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"Parser_2", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        Element body = root.getChild("body");
        String pay_status = body.getChildTextTrim("pay_status");
        String bank_remark = body.getChildTextTrim("bank_remark");
        if ("4".equals(pay_status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"Parser_5", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]), (String)pay_status, (String)ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"Parser_4", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]));
        } else if ("5".equals(pay_status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"Parser_1", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]), (String)pay_status, (String)bank_remark);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"Parser_2", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]), (String)pay_status, (String)bank_remark);
        }
    }

    public static PaymentInfo findPaymentInfo(List<PaymentInfo> paymentInfos, String recAccount, String amount) throws EBServiceException {
        for (PaymentInfo pay : paymentInfos) {
            if (!pay.getIncomeAccNo().equals(recAccount) || !pay.getAmount().toString().equals(amount)) continue;
            return pay;
        }
        return null;
    }
}

