/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.glb.dc.services.utils;

import java.io.InputStream;
import java.io.OutputStream;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HttpSendAndRecUtils {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(HttpSendAndRecUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendAndRecv(String rsqt) {
        try {
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            factory.setUri("/corporbank/httpAccess");
            factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
            IConnection conn = factory.createExchangeConnection();
            conn.openConnection();
            try (OutputStream os = conn.getOutputStream();){
                String rsp = "";
                try {
                    IOUtils.sendFully((OutputStream)os, (String)rsqt);
                    try (InputStream is = conn.getInputStream();){
                        rsp = IOUtils.readFully((InputStream)is);
                    }
                }
                catch (Throwable t) {
                    RequestContextUtils.getRequestContext().setThrowableAfterSend(t);
                }
                String string = HttpSendAndRecUtils.batchInfoParser(rsp);
                return string;
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static String batchInfoParser(String rsp) {
        String encoding = RequestContextUtils.getCharset();
        Element ebank_root = JDomUtils.string2Root((String)rsp, (String)encoding);
        Element body = ebank_root.getChild("body");
        String batchNo = body.getChildTextTrim("batchNo");
        logger.info("\u5f97\u5230\u7f51\u94f6\u6279\u6b21\u53f7\u4e3a\uff1a" + batchNo);
        return batchNo;
    }
}

