/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hbb.dc.service.payment.single;

import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hbb.dc.util.HeadPacker;
import kd.ebg.aqap.banks.hbb.dc.util.HeadParser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayImpl.class);
    private static final String TRANCODE = "eb2e-transfer.TransferResultQry";

    public void configFactory(ConnectionFactory factory) {
        String s = "/eb2e/eb2e-transfer.TransferResultQry.do?";
        s = s + "userPassword=" + RequestContextUtils.getParameter().getBankParameter("userPassword") + "&SIGDATA=1&_locale=zh_CN";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)HeadPacker.buildHead(TRANCODE, ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"payerAcNo", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        JDomUtils.addChild((Element)body, (String)"ERPJnlNo", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"startDate", (String)DateUtil.formatDate((LocalDate)((PaymentInfo)paymentInfos.get(0)).getSubmitSuccessTime().toLocalDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)DateUtil.formatDate((LocalDate)((PaymentInfo)paymentInfos.get(0)).getSubmitSuccessTime().toLocalDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"currentIndex", (String)"1");
        JDomUtils.addChild((Element)body, (String)"pageSize", (String)"100");
        String requestXml = JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return requestXml;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element body = bank_root.getChild("Body");
        BankResponse bankResponse = HeadParser.parserCommonInfo(bank_root);
        String bankStatus = bankResponse.getResponseCode();
        if (!"00000000".equalsIgnoreCase(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        List lists = body.getChildren("list");
        if (lists.size() == 0) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            for (Object element : lists) {
                String returnCode = JDomUtils.getChildTextTrim((Element)((Element)element), (String)"processState");
                this.logger.info("\u8fd4\u56de\u7801\u4e3a\uff1a" + returnCode + "--" + bankStatus);
                if ("OK".equalsIgnoreCase(returnCode)) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankStatus, (String)bankResponse.getResponseMessage());
                    continue;
                }
                if ("FL".equalsIgnoreCase(returnCode)) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankStatus, (String)bankResponse.getResponseMessage());
                    continue;
                }
                if ("UC".equalsIgnoreCase(returnCode) || "WAH".equalsIgnoreCase(returnCode) || "WAP".equalsIgnoreCase(returnCode) || "WCK".equalsIgnoreCase(returnCode) || "WMP".equalsIgnoreCase(returnCode)) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
                    continue;
                }
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankStatus, (String)bankResponse.getResponseMessage());
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "TransferResultQry";
    }

    public String getBizDesc() {
        return "";
    }
}

