/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dbs.dc.services;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dbs.dc.services.payment.outer.RTGSPayment;
import kd.ebg.aqap.business.payment.atomic.AbstractCheckImpl;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.Rule;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DBSCheck
extends AbstractCheckImpl {
    public List<Rule> rule(PaymentInfo paymentInfo) {
        if (paymentInfo.getImplClassName().equalsIgnoreCase(RTGSPayment.class.getName())) {
            return Lists.newArrayList((Object[])new Rule[]{new Rule(true, "PASS")});
        }
        String incomeSwiftCode = paymentInfo.getIncomeSwiftCode();
        String incomeAddress = paymentInfo.getIncomeAddress();
        String incomeAccName = paymentInfo.getIncomeAccName();
        String explanation = paymentInfo.getExplanation();
        Rule r1 = new Rule(!StringUtils.isEmpty((String)incomeSwiftCode) && DBSCheck.isNotContainChinese(incomeSwiftCode), ResManager.loadKDString((String)"\u6536\u6b3e\u94f6\u884cSwiftCode\u4e3a\u7a7a\u6216\u5305\u542b\u4e2d\u6587\u3001\u4e2d\u6587\u7b26\u53f7\u3002", (String)"DBSCheck_0", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]));
        Rule r2 = new Rule(!StringUtils.isEmpty((String)incomeAddress) && DBSCheck.isNotContainChinese(incomeAddress), ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u5730\u5740\u4e3a\u7a7a\u6216\u5305\u542b\u4e2d\u6587\u3001\u4e2d\u6587\u7b26\u53f7\u3002", (String)"DBSCheck_1", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]));
        Rule r3 = new Rule(!StringUtils.isEmpty((String)incomeAccName) && DBSCheck.isNotContainChinese(incomeAccName), ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u6237\u540d\u4e3a\u7a7a\u6216\u5305\u542b\u4e2d\u6587\u3001\u4e2d\u6587\u7b26\u53f7\u3002", (String)"DBSCheck_2", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]));
        Rule r4 = new Rule(StringUtils.isEmpty((String)explanation) || DBSCheck.isNotContainChinese(explanation), ResManager.loadKDString((String)"\u9644\u8a00\u5305\u542b\u4e2d\u6587\u3001\u4e2d\u6587\u7b26\u53f7\u3002", (String)"DBSCheck_3", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]));
        return Lists.newArrayList((Object[])new Rule[]{r1, r2, r3, r4});
    }

    public static boolean isNotContainChinese(String str) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5\uff01\uff0c\u3002\uff08\uff09\u300a\u300b\u201c\u201d\uff1f\uff1a\uff1b\u3010\u3011]");
        Matcher m = p.matcher(str);
        return !m.find();
    }
}

