/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dbs.dc.services;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dbs.dc.services.utils.PgpHelper;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DBS_DC_Parser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DBS_DC_Parser.class);

    public static void checkError(JSONObject total) {
        JSONObject error = total.getJSONObject("error");
        if (error != null) {
            String statusCode = error.getString("status");
            String description = error.getString("description");
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"API\u63a5\u53e3\u4ea4\u4e92\u5f02\u5e38\uff0c%1$s %2$s\u3002", (String)"DBS_DC_Parser_4", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), statusCode, description));
        }
    }

    public static void parseInfo(String origin, List<PaymentInfo> paymentInfos) {
        try {
            JSONObject total = JSONObject.parseObject((String)origin);
            DBS_DC_Parser.checkError(total);
            JSONArray txnResponsesList = total.getJSONArray("txnResponses");
            JSONObject txnResponses = txnResponsesList != null ? txnResponsesList.getJSONObject(0) : total.getJSONObject("txnResponse");
            String txnStatus = txnResponses.getString("txnStatus");
            String txnStatusDescription = txnResponses.getString("txnStatusDescription");
            if ("RJCT".equalsIgnoreCase(txnStatus)) {
                String txnRejectCode = txnResponses.getString("txnRejectCode");
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)txnRejectCode, (String)txnStatusDescription);
            } else {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)txnStatus, (String)txnStatusDescription);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u62a5\u6587\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u62a5\u6587\u53d1\u751f\u5f02\u5e38:%s\u3002", (String)"DBS_DC_Parser_5", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public static void parsePay(List<PaymentInfo> paymentInfos, String rspStr) {
        String origin;
        try {
            origin = PgpHelper.decry(rspStr);
        }
        catch (Throwable e) {
            logger.error("\u89e3\u5bc6\u9a8c\u7b7e\u65f6\u53d1\u751f\u5f02\u5e38", e);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u5bc6\u9a8c\u7b7e\u65f6\u53d1\u751f\u5f02\u5e38:%s\u3002", (String)"DBS_DC_Parser_6", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        DBS_DC_Parser.parseInfo(origin, paymentInfos);
    }

    public static void parseAck(PaymentInfo info, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElement((Element)body, (String)"rspPara");
        String status = JDomUtils.getChildText((Element)rspPara, (String)"status");
        String code = JDomUtils.getChildText((Element)rspPara, (String)"code");
        String msg = JDomUtils.getChildText((Element)rspPara, (String)"msg");
        if ("BCC_PAY_SUCCESS".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)"", (String)code, (String)msg);
        } else if ("BCC_PAY_FAIL".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)"", (String)code, (String)msg);
        } else if ("BCC_PAY_SUBMT_SUCCESS".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)code, (String)msg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)code, (String)msg);
        }
    }

    public static BankResponse parseHeader(Element root) {
        Element Head = JDomUtils.getChildElementNotNull((Element)root, (String)"head");
        String IBSReturnCode = JDomUtils.getChildTextNotNull((Element)Head, (String)"rspcode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"DBS_DC_Parser_3", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]));
        String IBSReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Head, (String)"rspMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }
}

