/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dbs.dc.services.payment.querypay;

import com.alibaba.fastjson.JSONObject;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dbs.dc.services.DBS_DC_Packer;
import kd.ebg.aqap.banks.dbs.dc.services.DBS_DC_Parser;
import kd.ebg.aqap.banks.dbs.dc.services.utils.DbsHelper;
import kd.ebg.aqap.banks.dbs.dc.services.utils.FrontProxy;
import kd.ebg.aqap.banks.dbs.dc.services.utils.PgpHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayImpl.class);

    public EBBankPayResponse queryPay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String queryType = RequestContextUtils.getBankParameterValue((String)"queryType");
        if ("push".equalsIgnoreCase(queryType)) {
            try {
                String rqstStr = DBS_DC_Packer.packAck(paymentInfo);
                this.logger.info("\u5411\u4ee3\u7406\u7a0b\u5e8f\u53d1\u9001\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001\u62a5\u6587\uff1a" + rqstStr);
                FrontProxy frontProxy = new FrontProxy();
                String rspStr = frontProxy.sendAndRecvMsg(rqstStr);
                this.logger.info("\u63a5\u6536\u4ee3\u7406\u7a0b\u5e8f\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr);
                EBBankPayResponse ebBankPayResponse = new EBBankPayResponse(paymentInfos);
                DBS_DC_Parser.parseAck(paymentInfo, rspStr);
                Long submitSuccessTime = paymentInfo.getSubmitSuccessTime().toInstant(ZoneOffset.of("+8")).toEpochMilli();
                Long now = new Date().getTime();
                if ((now - submitSuccessTime) / 60000L > 5L && "RECORD_IS_NOT_EXIST".equals(paymentInfo.getBankStatus())) {
                    ebBankPayResponse = this.queryFromBank(request);
                }
                return ebBankPayResponse;
            }
            catch (Throwable e) {
                this.logger.error("\u661f\u5c55\u94f6\u884c\u540c\u6b65\u4ed8\u6b3e\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38", e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u661f\u5c55\u94f6\u884c\u540c\u6b65\u4ed8\u6b3e\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), (Throwable)e);
            }
        }
        return this.queryFromBank(request);
    }

    private EBBankPayResponse queryFromBank(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        String response = DbsHelper.sendRequestAndReceive(RequestContextUtils.getBankParameterValue((String)"queryPayUri"), ((PaymentInfo)paymentInfos.get(0)).getAccNo(), this.pack(request));
        return this.parse(request, response);
    }

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        JSONObject header = DBS_DC_Packer.createHeader(info.getAccNo(), info.getAccCountry());
        JSONObject txnInfo = new JSONObject();
        txnInfo.put("txnType", (Object)"TSE");
        txnInfo.put("enqType", (Object)"REM");
        JSONObject txnEnquiry = new JSONObject();
        txnEnquiry.put("enqAccountNo", (Object)info.getAccNo());
        txnEnquiry.put("customerReference", (Object)info.getBankDetailSeqId());
        JSONObject total = new JSONObject();
        total.put("header", (Object)header);
        total.put("txnInfo", (Object)txnInfo);
        total.put("txnEnquiry", (Object)txnEnquiry);
        try {
            return PgpHelper.encry(total.toJSONString());
        }
        catch (Throwable e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u52a0\u5bc6\u65f6\u53d1\u751f\u5f02\u5e38:%s\u3002", (String)"QueryPayImpl_7", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        String origin;
        List paymentInfos = bankPayRequest.getPaymentInfos();
        try {
            origin = PgpHelper.decry(rspStr);
        }
        catch (Throwable e) {
            this.logger.error("\u89e3\u5bc6\u9a8c\u7b7e\u65f6\u53d1\u751f\u5f02\u5e38", e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u5bc6\u9a8c\u7b7e\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return this.parseInfo(origin, paymentInfos);
    }

    public EBBankPayResponse parseInfo(String origin, List<PaymentInfo> paymentInfos) {
        JSONObject total = JSONObject.parseObject((String)origin);
        DBS_DC_Parser.checkError(total);
        JSONObject txnEnqResponse = total.getJSONObject("txnEnqResponse");
        String enqStatus = txnEnqResponse.getString("enqStatus");
        if ("RJCT".equalsIgnoreCase(enqStatus)) {
            String enqStatusDescription = txnEnqResponse.getString("enqStatusDescription");
            String enqRejectCode = txnEnqResponse.getString("enqRejectCode");
            EBGBusinessUtils.setPaymentsWithoutStauts(paymentInfos, (String)ResManager.loadKDString((String)"TSE\u63a5\u53e3\u8c03\u7528\u8fd4\u56deRJCT", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), (String)enqRejectCode, (String)enqStatusDescription);
        } else {
            String txnStatus = txnEnqResponse.getString("txnStatus");
            String txnStatusDescription = txnEnqResponse.getString("txnStatusDescription");
            if ("RJCT".equalsIgnoreCase(txnStatus)) {
                String txnRejectCode = txnEnqResponse.getString("txnRejectCode");
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_4", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), (String)txnRejectCode, (String)txnStatusDescription);
            } else if (txnStatus.equalsIgnoreCase("ACSP") || txnStatus.equalsIgnoreCase("ACTC") || txnStatus.equalsIgnoreCase("ACWC")) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_5", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), (String)txnStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_5", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]));
            } else {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayImpl_6", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), (String)txnStatus, (String)txnStatusDescription);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

