/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zyb.dc.services.payment.salary.batch;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zyb.dc.services.payment.salary.batch.SalaryBatchPayQueryImpl;
import kd.ebg.aqap.banks.zyb.dc.services.payment.salary.batch.SalaryPacker;
import kd.ebg.aqap.banks.zyb.dc.services.payment.salary.batch.SalaryParser;
import kd.ebg.aqap.banks.zyb.dc.utils.Utils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class SalaryBatchPayImpl
extends AbstractPayImpl
implements IPay {
    SalaryPacker salaryPacker = new SalaryPacker();
    SalaryParser salaryParser = new SalaryParser();

    public int getBatchSize() {
        return 50;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryBatchPayQueryImpl.class;
    }

    public String getDeveloper() {
        return "jiewen_liang";
    }

    public String getBizCode() {
        return "05B2EAgentPaySalary";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5de5\u8d44\u4ee3\u53d1", (String)"SalaryBatchPayImpl_0", (String)"ebg-aqap-banks-zyb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_salary".equals(paymentInfo.getSubBizType());
    }

    public String pack(BankPayRequest request) {
        return this.salaryPacker.packPay(Utils.listToArray(request.getPaymentInfos()));
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return this.salaryParser.parsePay(Utils.listToArray(request.getPaymentInfos()), responseStr);
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("/b2e/05B2EAgentPaySalary.do?").append("userPassword=").append(RequestContextUtils.getParameter().getBankParameter("Password")).append("&SIGDATA=1");
        factory.setUri(sb.toString());
        factory.setHttpHeader("content-type", "text/xml; charset=GBK");
    }
}

