/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.balance;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ceb.dc.utils.BankUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        String accNo = acnt.getAccNo();
        String batchID = BankUtils.createBatchID();
        Element root = JDomUtils.createRoot((String)"Transaction");
        BankUtils.createSystemHead(root, request.getAcnt().getAccNo());
        Element transHead = JDomUtils.addChild((Element)root, (String)"TransHead");
        JDomUtils.addChild((Element)transHead, (String)"TransCode", (String)"b2e001014");
        JDomUtils.addChild((Element)transHead, (String)"BatchID", (String)batchID);
        JDomUtils.addChild((Element)transHead, (String)"JnlDate", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)transHead, (String)"JnlTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        Element transContent = JDomUtils.addChild((Element)root, (String)"TransContent");
        Element reqData = JDomUtils.addChild((Element)transContent, (String)"ReqData");
        JDomUtils.addChild((Element)reqData, (String)"ClientPatchID", (String)BankUtils.createClientPatchID(batchID, 0));
        JDomUtils.addChild((Element)reqData, (String)"CXAcNo", (String)accNo);
        JDomUtils.addChild((Element)reqData, (String)"startTime", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)reqData, (String)"endTime", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Namespace namespace = root.getNamespace();
        BankAcnt acnt = request.getAcnt();
        Element transContent = root.getChild("TransContent", namespace);
        if (null == transContent) {
            String ReturnCode = root.getChildTextTrim("ReturnCode", namespace);
            String ReturnMsg = root.getChildTextTrim("ReturnMsg", namespace);
            String error = root.getChildTextTrim("error", namespace);
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)ReturnCode, (String)(ReturnMsg + error)));
        }
        String returnCode = transContent.getChildTextTrim("ReturnCode", namespace);
        String returnMsg = transContent.getChildTextTrim("ReturnMsg", namespace);
        Element BatchRespList = transContent.getChild("BatchRespList", namespace);
        List localList = BatchRespList.getChildren("RespData", namespace);
        ArrayList<BalanceInfo> infos = new ArrayList<BalanceInfo>(1);
        for (Element data : localList) {
            String accountNo = data.getChildTextTrim("AcNo", namespace);
            String balance = data.getChildTextTrim("balance", namespace);
            String currency = data.getChildTextTrim("montype", namespace);
            String availableBalance = data.getChildTextTrim("availableBalance", namespace);
            String date = data.getChildTextTrim("date", namespace);
            if (!"0000".equals(returnCode)) {
                throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)returnCode, (String)returnMsg));
            }
            BalanceInfo balanceInfo = new BalanceInfo();
            this.setBankAcnt(balanceInfo, request.getBankAcntList(), accountNo);
            this.setBankCurrency(balanceInfo, request.getBankCurrency(), currency);
            this.setCurrentBalance(balanceInfo, balance);
            balanceInfo.setBalanceDateTime(LocalDateTime.parse(date + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            if (StringUtils.isEmpty((String)availableBalance)) {
                this.setAvailableBalance(balanceInfo, balance);
            } else {
                this.setAvailableBalance(balanceInfo, availableBalance);
            }
            infos.add(balanceInfo);
        }
        return new EBBankBalanceResponse(infos);
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "b2e001014";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d", (String)"HisBalanceImpl_5", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]);
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        StringBuilder sb = new StringBuilder();
        sb.append("/ent/b2e001014.do");
        sb.append("?usrID=");
        sb.append(RequestContextUtils.getBankParameterValue((String)"UserID"));
        sb.append("&userPassword=");
        sb.append(RequestContextUtils.getBankParameterValue((String)"UserPassword"));
        factory.setUri(sb.toString());
        return factory;
    }
}

