/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.balance.balanceCheck;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ceb.dc.utils.BankUtils;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceReconciliationImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceReconciliation;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceReconciliationRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceReconciliationResponse;
import kd.ebg.aqap.business.balancereconciliation.utils.BalanceReconciliationState;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationBusinessUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class BalanceReconciliationImpl
extends AbstractBalanceReconciliationImpl
implements IBalanceReconciliation {
    public String pack(BankBalanceReconciliationRequest bankBalanceReconciliationRequest) {
        String accNo = bankBalanceReconciliationRequest.getDetail().getAccNo();
        Element root = JDomUtils.createRoot((String)"Transaction");
        BankUtils.createSystemHead(root, accNo);
        Element transHead = JDomUtils.addChild((Element)root, (String)"TransHead");
        JDomUtils.addChild((Element)transHead, (String)"TransCode", (String)"b2e004011");
        JDomUtils.addChild((Element)transHead, (String)"BatchID", (String)BankUtils.createBatchIDBy8ID(accNo));
        LocalDateTime now = LocalDateTime.now();
        JDomUtils.addChild((Element)transHead, (String)"JnlDate", (String)now.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)transHead, (String)"JnlTime", (String)now.format(DateTimeFormatter.ofPattern("HHmmss")));
        Element transContent = JDomUtils.addChild((Element)root, (String)"TransContent");
        JDomUtils.addChild((Element)transContent, (String)"RequestNum", (String)"1");
        Element reqData1 = JDomUtils.addChild((Element)transContent, (String)"BatchReqList");
        JDomUtils.addChild((Element)reqData1, (String)"ClientPatchID", (String)Sequence.gen18Sequence());
        JDomUtils.addChild((Element)reqData1, (String)"AcNo", (String)accNo);
        BalanceReconciliationDetail detail = bankBalanceReconciliationRequest.getDetail();
        JDomUtils.addChild((Element)reqData1, (String)"ServiceNum", (String)detail.getBiz("serviceNum"));
        JDomUtils.addChild((Element)reqData1, (String)"Year", (String)detail.getMonth().substring(0, 4));
        JDomUtils.addChild((Element)reqData1, (String)"Month", (String)detail.getMonth().substring(4, 6));
        JDomUtils.addChild((Element)reqData1, (String)"IsAccord", (String)"0");
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceReconciliationResponse parse(BankBalanceReconciliationRequest bankBalanceReconciliationRequest, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Namespace namespace = root.getNamespace();
        Element transContent = root.getChild("TransContent", namespace);
        String returnCode = transContent.getChildTextTrim("ReturnCode", namespace);
        String returnMsg = transContent.getChildTextTrim("ReturnMsg", namespace);
        if (!"0000".equals(returnCode)) {
            throw EBExceiptionUtil.serviceException((String)("bankResponse is failed,reason-->" + returnMsg));
        }
        Element batchRespList = transContent.getChild("BatchRespList", namespace);
        List respData = batchRespList.getChildren("RespData", namespace);
        Element element = (Element)respData.get(0);
        String status = element.getChildText("ReturnCode", namespace);
        String msg = element.getChildText("ReturnMsg", namespace);
        BalanceReconciliationDetail detail = bankBalanceReconciliationRequest.getDetail();
        if ("0000".equals(status)) {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.SUCCESS, (String)status, (String)msg);
        } else {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.FAIL, (String)status, (String)msg);
        }
        return new EBBankBalanceReconciliationResponse(detail);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "b2e004011";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u8d26\u53cd\u9988", (String)"BalanceReconciliationImpl_0", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceReconciliationRequest bankBalanceReconciliationRequest) {
        return true;
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        StringBuilder sb = new StringBuilder();
        sb.append("/ent/b2e004011.do?usrID=");
        sb.append(RequestContextUtils.getBankParameterValue((String)"UserID"));
        sb.append("&userPassword=");
        sb.append(RequestContextUtils.getBankParameterValue((String)"UserPassword"));
        factory.setUri(sb.toString());
        return factory;
    }
}

