/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdb.dc.utils;

import java.util.Calendar;
import java.util.Date;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TCommon {
    static EBGLogger logger = EBGLogger.getInstance().getLogger(TCommon.class);

    public static String getSerialNumber() {
        StringBuilder sb = new StringBuilder("YQ");
        sb.append(RequestContextUtils.getBankParameterValue((String)"GID"));
        String sdate = RequestContextUtils.getBankParameterValue((String)"BankResponseDate");
        if (!StringUtils.isEmpty((String)sdate)) {
            sb.append(sdate.trim());
        } else {
            sb.append(DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        }
        sb.append(DateTimeUtils.format((Date)Calendar.getInstance().getTime(), (String)"HHmmss")).append(Sequence.getAutoincrementNumberWithCycle((int)6));
        return sb.toString();
    }

    public static Element createCommonHead(String TransCode) {
        Element Packet = JDomUtils.createRoot((String)"Packet");
        Element Data = JDomUtils.addChild((Element)Packet, (String)"Data");
        Element Pub = JDomUtils.addChild((Element)Data, (String)"Pub");
        JDomUtils.addChild((Element)Pub, (String)"TransCode", (String)TransCode);
        JDomUtils.addChild((Element)Pub, (String)"GID", (String)RequestContextUtils.getBankParameterValue((String)"GID"));
        JDomUtils.addChild((Element)Pub, (String)"BankCode", (String)RequestContextUtils.getBankParameterValue((String)"BankCode"));
        Date d = new Date();
        JDomUtils.addChild((Element)Pub, (String)"TransDate", (String)DateTimeUtils.format((Date)d, (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)Pub, (String)"TransTime", (String)DateTimeUtils.format((Date)d, (String)"HHmmss"));
        JDomUtils.addChild((Element)Pub, (String)"Fseqno", (String)TCommon.getSerialNumber());
        return Packet;
    }

    public static String getHttpUrl(String type) {
        String httpuri = "";
        if ("sign".equalsIgnoreCase(type)) {
            httpuri = "/debankclient/SignTxControl";
        } else {
            try {
                httpuri = RequestContextUtils.getBankParameterValue((String)"HttpUri");
            }
            catch (EBServiceException e) {
                logger.error(e.getMessage());
            }
        }
        return httpuri;
    }

    public static BankResponse parseBankResponse(Element head) {
        String respondInfo;
        BankResponse response = new BankResponse();
        String respondCode = head.getChildTextTrim("RetCode");
        String responseMessage = respondInfo = head.getChildTextTrim("RetMsg");
        response.setResponseCode(respondCode);
        response.setResponseMessage(responseMessage);
        return response;
    }
}

