/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sjb.cms.services.payment.salary;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sjb.cms.services.payment.salary.ProxyUpload;
import kd.ebg.aqap.banks.sjb.cms.utils.TCommon;
import kd.ebg.aqap.banks.sjb.cms.utils.TPacker;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(PayPacker.class);

    public static String packPay(List<PaymentInfo> paymentInfos) throws EBServiceException {
        StringBuilder sb = new StringBuilder();
        BigDecimal totalAmt = new BigDecimal("0.00");
        PaymentInfo paymentInfo = null;
        for (int i = 0; i < paymentInfos.size(); ++i) {
            paymentInfo = paymentInfos.get(0);
            BigDecimal amt = paymentInfo.getAmount();
            totalAmt = totalAmt.add(amt);
            sb.append(paymentInfo.getIncomeAccNo()).append("|");
            sb.append(paymentInfo.getCurrency()).append("|");
            sb.append(paymentInfo.getIncomeAccName()).append("|");
            sb.append("").append("|");
            String amount = amt.setScale(2, 1).toPlainString();
            sb.append(amount).append("|");
            sb.append(paymentInfo.getExplanation()).append("|");
        }
        String tr_code = "300002";
        paymentInfo = paymentInfos.get(0);
        Element ap = TPacker.createCommonHead(tr_code, paymentInfo.getPackageId(), "1");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"as_acno", (String)"");
        JDomUtils.addChild((Element)body, (String)"supply_item", (String)"0");
        JDomUtils.addChild((Element)body, (String)"amt", (String)totalAmt.setScale(2, 1).toPlainString());
        JDomUtils.addChild((Element)body, (String)"count", (String)("" + paymentInfos.size()));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)paymentInfo.getExplanation());
        String fileName = paymentInfo.getPackageId() + ".txt";
        JDomUtils.addChild((Element)body, (String)"file_name", (String)fileName);
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        try {
            ProxyUpload proxyUpload = new ProxyUpload(sb.toString());
            proxyUpload.doBiz(fileName);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"###[\u4ee3\u53d1\u5de5\u8d44]\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (String)"PayPacker_4", (String)"ebg-aqap-banks-sjb-cms", (Object[])new Object[0]), (Throwable)e);
        }
        return TCommon.createCommonMsg(xmlMsg);
    }
}

