/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ynhtb.dc.utils.file;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.framework.sftp.SftpClientImp;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class YnhtbFileUtils
extends AbstractImpl {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(YnhtbFileUtils.class);
    String split = "|!";

    public String packBatchPayUploadFileContent(List<PaymentInfo> paymentInfos) throws EBServiceException {
        try {
            StringBuilder fileContent = new StringBuilder();
            for (PaymentInfo paymentInfo : paymentInfos) {
                fileContent.append(paymentInfo.getDetailSeqID()).append(this.split).append(paymentInfo.getAccNo()).append(this.split).append(paymentInfo.getAccName()).append(this.split).append(paymentInfo.is2SameBank() ? "0" : "1").append(this.split).append(paymentInfo.getIncomeAccNo()).append(this.split).append(paymentInfo.getIncomeAccName()).append(this.split).append(paymentInfo.getIncomeCnaps()).append(this.split).append(paymentInfo.getIncomeBankName()).append(this.split).append(paymentInfo.getIsoCurrencyCode()).append(this.split).append(paymentInfo.getAmount().toString()).append(this.split).append(paymentInfo.is2Individual() ? "0" : "1").append(this.split).append(paymentInfo.getBankDetailSeqId()).append(this.split).append(paymentInfo.getExplanation()).append("\r\n");
            }
            return fileContent.toString();
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public Map<String, Map<String, String>> parseBatchPayDownloadFileContent(String fileContent) throws EBServiceException {
        try {
            String[] record = fileContent.split("\\r\\n");
            HashMap<String, Map<String, String>> results = new HashMap<String, Map<String, String>>(record.length);
            for (int i = 0; i < record.length; ++i) {
                String perRecord = record[i];
                logger.info("\u5f53\u524d\u8bfb\u53d6\u5230\u7684\u4ea4\u6613\u7ed3\u679c\u8bb0\u5f55:{}", (Object)perRecord);
                String[] cols = perRecord.split("\\|\\!", -1);
                HashMap<String, String> payResult = new HashMap<String, String>();
                payResult.put("TfrDate", cols[0]);
                payResult.put("SeqNo", cols[1]);
                payResult.put("TranSeqNo", cols[2]);
                payResult.put("AcctNo", cols[3]);
                payResult.put("Amount", cols[4]);
                payResult.put("TranStatus", cols[5]);
                payResult.put("TranStatusDesc", cols[6]);
                results.put(cols[1], payResult);
            }
            return results;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String uploadFileToSftp(String fileName, String fileText) {
        EBContext context = EBContext.getContext();
        IParameter parameter = context.getParameter();
        SftpClientImp sftp = new SftpClientImp(parameter.getBankParameter("sftpHost"), parameter.getBankParameterAsInt("sftpPort"), parameter.getBankParameter("sftpUserName"), parameter.getBankParameter("sftpPwd"), 60000);
        try {
            sftp.open();
            sftp.mkdirIfDirNotExist(parameter.getBankParameter("sftpUploadPath"));
            sftp.cd(parameter.getBankParameter("sftpUploadPath"));
            ByteArrayInputStream in = new ByteArrayInputStream(fileText.getBytes(RequestContextUtils.getCharset()));
            sftp.put(fileName, (InputStream)in);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        finally {
            try {
                sftp.close();
            }
            catch (Exception e) {
                logger.error("\u5173\u95edsftp\u6d41\u5931\u8d25");
            }
        }
        return null;
    }

    public static String getFileFromSftp(String fileName) {
        InputStreamReader reader;
        EBContext context = EBContext.getContext();
        IParameter parameter = context.getParameter();
        SftpClientImp sftp = new SftpClientImp(parameter.getBankParameter("sftpHost"), parameter.getBankParameterAsInt("sftpPort"), parameter.getBankParameter("sftpUserName"), parameter.getBankParameter("sftpPwd"), 60000);
        StringBuilder sb = new StringBuilder();
        try {
            sftp.open();
            sftp.cd(parameter.getBankParameter("sftpDownloadPath"));
            logger.info("fileName\u662f\uff1a" + fileName);
            InputStream is = sftp.get(fileName);
            reader = new InputStreamReader(is, RequestContextUtils.getCharset());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        BufferedReader bfReader = new BufferedReader(reader);
        try {
            String line;
            while (!StringUtils.isEmpty((String)(line = bfReader.readLine()))) {
                sb.append(line).append("\r\n");
            }
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bfb\u53d6\u94f6\u884c\u8fd4\u56de\u7684\u5e94\u7b54\u6587\u4ef6\u51fa\u9519\u3002", (String)"YnhtbFileUtils_0", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        try {
            sftp.close();
        }
        catch (Exception localException1) {
            logger.error("\u5173\u95edsftp\u6d41\u5931\u8d25");
        }
        return sb.toString();
    }
}

