/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nhb.dc.utils;

import java.util.Date;
import kd.ebg.aqap.banks.nhb.dc.utils.Base64;
import kd.ebg.aqap.banks.nhb.dc.utils.GzipTool;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Packer {
    public static Element createHead(String tranCode) {
        return Packer.createHead(tranCode, Sequence.genSequence());
    }

    public static Element createHead(String tranCode, String seqNo) {
        Element head = new Element("Head");
        JDomUtils.addChild((Element)head, (String)"TrsCode", (String)tranCode);
        JDomUtils.addChild((Element)head, (String)"CifNo", (String)RequestContextUtils.getBankParameterValue((String)"CifNo"));
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        JDomUtils.addChild((Element)head, (String)"ERPJnlNo", (String)seqNo);
        return head;
    }

    public static String compress(String msg) throws Exception {
        String encoding = "GBK";
        byte[] gizpBytes = GzipTool.gzipFile(msg, encoding);
        String base64Msg = Base64.encodeBytes(gizpBytes);
        return base64Msg;
    }

    public static String unCompress(String srcMsg) {
        String encoding = "GBK";
        byte[] gzipMsg = Base64.decode(srcMsg);
        return GzipTool.unGzipFile(gzipMsg, encoding);
    }

    public static String getUrl(String tranCode) {
        StringBuilder sb = new StringBuilder();
        sb.append("/eweb/");
        sb.append(tranCode);
        sb.append(".do");
        sb.append("?");
        sb.append("userPassword=").append(RequestContextUtils.getBankParameterValue((String)"userPassword"));
        sb.append("&SIGDATA=0");
        return sb.toString();
    }

    public static ConnectionFactory setConnectionFactory(ConnectionFactory factory, String tranCode) {
        factory.setUri(Packer.getUrl(tranCode));
        factory.setHttpHeader("Content-type", "application/stream");
        factory.setHttpHeader("Accept", "text/xml; *.*");
        factory.setHttpHeader("Accept-Encoding", "gzip,deflate");
        factory.setHttpHeader("content-encoding", RequestContextUtils.getCharset());
        return factory;
    }
}

