/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.bankversion;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.plugin.common.EbcAddBankListPlugin;
import kd.ebg.aqap.formplugin.repository.EbcBankLoginRepository;
import kd.ebg.aqap.formplugin.repository.EbcBankVersionRepository;

public class BankVersionListPlugin
extends EbcAddBankListPlugin
implements BeforeF7SelectListener {
    private static final String ENTITY_KEY_BANK = "aqap_bank";
    private static final String webUrl = "http://web20.kingdee.com/eb_cloud_cnaps/bankdetail?bankCode=%s&productVersion=EBGCLOUD";
    private EbcBankLoginRepository ebcBankLoginRepository = (EbcBankLoginRepository)SpringContextUtil.getBean(EbcBankLoginRepository.class);
    private EbcBankVersionRepository ebcBankVersionRepository = (EbcBankVersionRepository)SpringContextUtil.getBean(EbcBankVersionRepository.class);

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection;
        AtomicReference<String> bankCode;
        ListSelectedRowCollection listSelectedRowCollection2;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"disable_bank", (CharSequence)operateKey) && (listSelectedRowCollection2 = args.getListSelectedData()) != null && listSelectedRowCollection2.size() > 0) {
            listSelectedRowCollection2.forEach(selectedRow -> {
                String bankVersion = selectedRow.getNumber();
                boolean exitsBankLogin = this.ebcBankLoginRepository.exitsBankLoginByBankVersion(bankVersion);
                if (exitsBankLogin) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u94f6\u884c\u5df2\u7ecf\u5173\u8054\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u914d\u7f6e\uff0c\u8bf7\u5220\u9664\u4e4b\u540e\u518d\u7981\u7528\u3002", (String)"BankVersionListPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.ebcBankVersionRepository.disableByBankVersion(bankVersion);
                this.getView().invokeOperation("refresh");
            });
        }
        if (StringUtils.equals((CharSequence)"open_url", (CharSequence)operateKey)) {
            bankCode = new AtomicReference<String>("");
            listSelectedRowCollection = args.getListSelectedData();
            if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
                listSelectedRowCollection.forEach(selectedRow -> bankCode.set(selectedRow.getNumber()));
            }
            String url = String.format(webUrl, bankCode.get());
            this.getView().openUrl(url);
        }
        if ("show_bank_login".equals(formOperate.getOperateKey())) {
            bankCode = new AtomicReference();
            listSelectedRowCollection = args.getListSelectedData();
            if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
                listSelectedRowCollection.forEach(selectedRow -> {
                    Long bankVersionId = (Long)selectedRow.getPrimaryKeyValue();
                    bankCode.set((String)((Object)bankVersionId));
                });
            }
            HashMap customParams = Maps.newHashMapWithExpectedSize((int)16);
            customParams.put("bankVersionId", bankCode.get());
            this.showListPage("aqap_bank_login", "aqap_bos_templatetree", customParams);
        }
    }

    public void showListPage(String entityKey, String formId, Map<String, Object> customParams) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId(formId);
        showParameter.setBillFormId(entityKey);
        if (!CollectionUtils.isEmpty(customParams)) {
            showParameter.setCustomParams(customParams);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

