/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.common;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;

public class EbcCommonFilterContainerPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final String ENTITY_KEY_BANK_ACNT = "aqap_bank_acnt";
    private static final String ENTITY_KEY_BANK_Login = "aqap_bank_login";
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private FilterContainerInitArgs initArgs;

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        ListView view = (ListView)this.getView();
        ControlFilters controlFilters = view.getControlFilters();
        List bankVersionIds = controlFilters.getFilter("bank_version.id");
        List bankLoginIds = controlFilters.getFilter("bank_login.id");
        if ("acc_no.id".equalsIgnoreCase(fieldName)) {
            args.getQfilters().clear();
            args.getQfilters().add(new QFilter("has_receipt", "=", (Object)"1"));
            if (bankVersionIds.size() > 0 && !"".equals(bankVersionIds.get(0))) {
                args.getQfilters().add(new QFilter("group.id", "=", bankVersionIds.get(0)));
            }
            if (bankLoginIds.size() > 0 && !"".equals(bankLoginIds.get(0))) {
                args.getQfilters().add(new QFilter("bank_login.id", "=", bankLoginIds.get(0)));
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)ENTITY_KEY_BANK_ACNT)) {
            IDataModel model = this.getModel();
            String bankVersion = (String)model.getDataEntity().get("bank_version.number");
            String bankLogin = (String)model.getDataEntity().get("bank_login.number");
            if (StringUtils.isNotBlank((CharSequence)bankVersion)) {
                model.getDataEntityType().getName();
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(100);
                QFilter qFilter = new QFilter("group.number", "=", (Object)bankVersion);
                qFilters.add(qFilter);
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.setShowApproved(false);
                if (StringUtils.isNotBlank((CharSequence)bankLogin)) {
                    QFilter qFilter2 = new QFilter("bank_login.number", "=", (Object)bankLogin);
                    qFilters.add(qFilter2);
                }
                QFilter qFilter3 = new QFilter("has_receipt", "=", (Object)"1");
                qFilters.add(qFilter3);
                showParameter.getListFilterParameter().setQFilters(qFilters);
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        FilterParameter filters = args.getFilterParameter();
        List qList = filters.getQFilters();
        String bankVersionId = "";
        String bankLoginId = "";
        String acntId = "";
        String startDateTime = "";
        String endDateTime = "";
        for (QFilter filter : qList) {
            if (filter.getProperty().startsWith("bank_version")) {
                bankVersionId = String.valueOf(filter.getValue());
                continue;
            }
            if (filter.getProperty().startsWith("bank_acnt")) {
                acntId = String.valueOf(filter.getValue());
                continue;
            }
            if (filter.getProperty().startsWith("bank_login")) {
                bankLoginId = String.valueOf(filter.getValue());
                continue;
            }
            if (!filter.getProperty().startsWith("trans_date")) continue;
            startDateTime = this.timeTranslate(filter.getValue());
            endDateTime = this.timeTranslateBeforeDay(((QFilter.QFilterNest)filter.getNests(true).get(0)).getFilter().getValue());
        }
        this.getPageCache().put("selectedBankId", bankVersionId);
        this.getPageCache().put("selectedBankLoginId", bankLoginId);
        this.getPageCache().put("selectedAcntId", acntId);
        this.getPageCache().put("startDateTime", startDateTime);
        this.getPageCache().put("endDateTime", endDateTime);
        this.filterContainerInit(this.initArgs);
    }

    private String timeTranslate(Object dateStr) {
        Date time = (Date)dateStr;
        String timeFormat = this.sdf.format(time);
        return timeFormat;
    }

    private String timeTranslateBeforeDay(Object dateStr) {
        Date time = (Date)dateStr;
        time = DateUtil.preDay((Date)time);
        String timeFormat = this.sdf.format(time);
        return timeFormat;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List currencyItems;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.equalsIgnoreCase("acc_no.number")) {
                List<ComboItem> acctItems = this.initAcctItemsList();
                currencyItems = commonFilterColumn.getComboItems();
                currencyItems.clear();
                commonFilterColumn.setComboItems(acctItems);
                continue;
            }
            if (!fieldName.equalsIgnoreCase("bank_login.number")) continue;
            List<ComboItem> bankLoginItems = this.initBankLoginItemsList();
            currencyItems = commonFilterColumn.getComboItems();
            currencyItems.clear();
            commonFilterColumn.setComboItems(bankLoginItems);
        }
    }

    protected List<ComboItem> initAcctItemsList() {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>(100);
        String selectProperties = "id, number, name";
        QFilter[] qfilters = StringUtil.isNotNil(this.getPageCache().get("selectedBankLoginId")) ? new QFilter[]{new QFilter("group.id", "=", (Object)this.getPageCache().get("selectedBankId")), new QFilter("bank_login.id", "=", (Object)this.getPageCache().get("selectedBankLoginId")), new QFilter("has_receipt", "=", (Object)"1")} : (StringUtil.isNotNil(this.getPageCache().get("selectedBankId")) ? new QFilter[]{new QFilter("group.id", "=", (Object)this.getPageCache().get("selectedBankId")), new QFilter("has_receipt", "=", (Object)"1")} : new QFilter[]{new QFilter("has_receipt", "=", (Object)"1")});
        DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)ENTITY_KEY_BANK_ACNT, (String)selectProperties, (QFilter[])qfilters);
        if (accountBanks != null && accountBanks.length > 0) {
            for (int i = 0; i < accountBanks.length; ++i) {
                DynamicObject cashAcct = accountBanks[i];
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("number")));
                item.setValue(cashAcct.getString("id"));
                acctItems.add(item);
            }
        }
        return acctItems;
    }

    protected List<ComboItem> initBankLoginItemsList() {
        ArrayList<ComboItem> bankLoginItems = new ArrayList<ComboItem>(100);
        QFilter[] qfilters = new QFilter[1];
        String selectProperties = "id, number, name";
        if (!StringUtil.isNotNil(this.getPageCache().get("selectedBankId"))) {
            return bankLoginItems;
        }
        qfilters[0] = new QFilter("group.id", "=", (Object)this.getPageCache().get("selectedBankId"));
        DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)ENTITY_KEY_BANK_Login, (String)selectProperties, (QFilter[])qfilters);
        if (accountBanks != null && accountBanks.length > 0) {
            for (int i = 0; i < accountBanks.length; ++i) {
                DynamicObject cashAcct = accountBanks[i];
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("number")));
                item.setValue(cashAcct.getString("id"));
                bankLoginItems.add(item);
            }
        }
        return bankLoginItems;
    }
}

