/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.log;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.formplugin.esclient.LogInfo;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.aqap.formplugin.plugin.common.EbcAddBankListPlugin;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.egf.common.framework.biz.BizTypeEnum;
import kd.ebg.egf.common.framework.frame.BusinessTypeUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.zip.StringCompressor;

public class ShowNewLogDetailPlugin
extends EbcAddBankListPlugin
implements IBillPlugin,
TabSelectListener {
    static final String EB = "eb_bankNewLogDetailPlugin_";
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String ENTITY_NAME_LIST = "aqap_new_log";
    private String SELECT_ALL_PROPERTIES_LIST = "id,biz_name,account,bank_version,bank_login,logger_batch_no,logger_detail_no,dt_query,logger_bank_no,logger_type,biz_seq,bd_bank_version.name";
    private String SELECT_ALL_PROPERTIES_DETAIL = "log_content_tag,dt_query,biz_seq,opname";

    public void afterCreateNewData(EventObject evt) {
        String logger_id = "";
        DynamicObject dynamicObject = null;
        String bankVersion = null;
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params != null) {
            Object log_id = params.get("log_id");
            if (log_id == null) {
                return;
            }
            logger_id = params.get("log_id").toString();
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{Long.parseLong(logger_id)});
            dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.ENTITY_NAME_LIST, (String)this.SELECT_ALL_PROPERTIES_LIST, (QFilter[])filter.toArray());
            bankVersion = dynamicObject.getString("bd_bank_version.name");
        }
        DynamicObjectCollection dType = QueryServiceHelper.query((String)"aqap_business_type", (String)"id,number,name", null);
        HashMap<String, String> businessType = new HashMap<String, String>(1);
        for (int i = 0; i < dType.size(); ++i) {
            DynamicObject object = (DynamicObject)dType.get(i);
            businessType.put(object.getString("number"), object.getString("name"));
        }
        if (dynamicObject != null) {
            this.getPageCache().put("eb_bankNewLogDetailPlugin_logger_bank_no", dynamicObject.getString("logger_bank_no"));
            this.getPageCache().put("eb_bankNewLogDetailPlugin_logger_batch_no", dynamicObject.getString("logger_batch_no"));
            this.getPageCache().put("eb_bankNewLogDetailPlugin_logger_detail_no", dynamicObject.getString("logger_detail_no"));
            this.getPageCache().put("eb_bankNewLogDetailPlugin_biz_name", dynamicObject.getString("biz_name"));
            this.getPageCache().put("eb_bankNewLogDetailPlugin_account", dynamicObject.getString("account"));
            this.getPageCache().put("eb_bankNewLogDetailPlugin_bank_version", bankVersion);
            this.getPageCache().put("eb_bankNewLogDetailPlugin_traceid", dynamicObject.getString("biz_seq"));
            this.getPageCache().put("eb_bankNewLogDetailPlugin_log_time", dynamicObject.getString("dt_query"));
            this.getModel().setValue("traceid", (Object)dynamicObject.getString("biz_seq"));
            this.getModel().setValue("account", (Object)dynamicObject.getString("account"));
            this.getModel().setValue("logger_batch_no", (Object)dynamicObject.getString("logger_batch_no"));
            this.getModel().setValue("logger_detail_no", (Object)dynamicObject.getString("logger_detail_no"));
            this.getModel().setValue("log_time", (Object)dynamicObject.getDate("dt_query"));
            this.getModel().setValue("bank_version", (Object)bankVersion);
            this.getModel().setValue("biz_name", businessType.get(dynamicObject.getString("biz_name")));
        }
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("tabpageap1");
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        FilterParameter filters = args.getFilterParameter();
        List qList = filters.getQFilters();
        String bankVersionId = "";
        String bizType = "";
        String startDateTime = "";
        String endDateTime = "";
        for (QFilter filter : qList) {
            if (filter.getProperty().startsWith("bd_bank_version")) {
                bankVersionId = this.getBankVersionID(String.valueOf(filter.getValue()));
                continue;
            }
            if (filter.getProperty().startsWith("bd_biz_name")) {
                bizType = this.getBizType(String.valueOf(filter.getValue()));
                continue;
            }
            startDateTime = this.timeTranslate(filter.getValue());
            endDateTime = this.timeTranslate(((QFilter.QFilterNest)filter.getNests(true).get(0)).getFilter().getValue());
        }
    }

    private String timeTranslate(Object dateStr) {
        Date time = (Date)dateStr;
        String timeFormat = this.sdf.format(time);
        return timeFormat;
    }

    private String getBankVersionID(String seqId) {
        String bankVersionId = "";
        String entityName = "aqap_bank";
        String selectFields = "number";
        QFilter filter = QFilter.of((String)"ID=?", (Object[])new Object[]{Long.parseLong(seqId)});
        DynamicObjectCollection collections = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filter.toArray());
        if (collections.size() == 1) {
            bankVersionId = ((DynamicObject)collections.get(0)).getString(0);
        }
        return bankVersionId;
    }

    private String getBizType(String seqId) {
        String bizType = "";
        String entityName = "aqap_business_type";
        String selectFields = "number";
        QFilter filter = QFilter.of((String)"ID=?", (Object[])new Object[]{Long.parseLong(seqId)});
        DynamicObjectCollection collections = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filter.toArray());
        if (collections.size() == 1) {
            bizType = ((DynamicObject)collections.get(0)).getString(0);
        }
        return bizType;
    }

    private String formatView(List<LogInfo> logInfos, String bizName, String logType) {
        String tips_business_bank = ResManager.loadKDString((String)"\u4e0d\u8bb0\u5f55\u94f6\u884c\u4e1a\u52a1\u65e5\u5fd7\uff0c\u5982\u6709\u9700\u8981\u8bf7\u5728\u94f6\u884c\u524d\u7f6e\u673a\u8fdb\u884c\u67e5\u770b\uff0c\u6216\u524d\u5f80\u94f6\u4f01\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u9875\u9762\uff0c\u70b9\u51fb\u8054\u673a\u67e5\u8be2\u540e\u53ef\u67e5\u770b\u3002", (String)"ShowNewLogDetailPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
        String tips_business_response = ResManager.loadKDString((String)"\u4e0d\u8bb0\u5f55\u94f6\u4f01\u54cd\u5e94\u4e1a\u52a1\u65e5\u5fd7\uff0c\u5982\u6709\u9700\u8981\u8bf7\u5728\u94f6\u4f01\u4e92\u8054\u65e5\u5fd7\u8fdb\u884c\u67e5\u770b\uff0c\u6216\u524d\u5f80\u94f6\u4f01\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u9875\u9762\uff0c\u70b9\u51fb\u8054\u673a\u67e5\u8be2\u540e\u53ef\u67e5\u770b\u3002", (String)"ShowNewLogDetailPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
        BizTypeEnum bizTypeEnum = BizTypeEnum.getBizTypeEnumByName((String)bizName);
        if (CollectionUtil.isEmpty(logInfos) && !bizTypeEnum.isNeedBizLog()) {
            if ("bussiness_bank".equalsIgnoreCase(logType)) {
                return tips_business_bank;
            }
            if ("bussiness_response".equalsIgnoreCase(logType)) {
                return tips_business_response;
            }
            return this.formatView(logInfos);
        }
        return this.formatView(logInfos);
    }

    private String formatView(List<LogInfo> logInfos) {
        StringBuilder stringBuilder = new StringBuilder();
        if (logInfos != null) {
            for (LogInfo info : logInfos) {
                stringBuilder.append(this.transFormat(info.getMessage()));
                stringBuilder.append("\r\n");
            }
            if (StringUtils.isEmpty(stringBuilder.toString())) {
                return MultiLang.getDataEmptyTip();
            }
            return stringBuilder.toString();
        }
        return MultiLang.getDataEmptyTip();
    }

    private String formatViewSimple(List<LogInfo> logInfos, String bizName, String logType) {
        String tips_business_bank = ResManager.loadKDString((String)"\u4e0d\u8bb0\u5f55\u94f6\u884c\u4e1a\u52a1\u65e5\u5fd7\uff0c\u5982\u6709\u9700\u8981\u8bf7\u5728\u94f6\u884c\u524d\u7f6e\u673a\u8fdb\u884c\u67e5\u770b\uff0c\u6216\u524d\u5f80\u94f6\u4f01\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u9875\u9762\uff0c\u70b9\u51fb\u8054\u673a\u67e5\u8be2\u540e\u53ef\u67e5\u770b\u3002", (String)"ShowNewLogDetailPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
        String tips_business_response = ResManager.loadKDString((String)"\u4e0d\u8bb0\u5f55\u94f6\u4f01\u54cd\u5e94\u4e1a\u52a1\u65e5\u5fd7\uff0c\u5982\u6709\u9700\u8981\u8bf7\u5728\u94f6\u4f01\u4e92\u8054\u65e5\u5fd7\u8fdb\u884c\u67e5\u770b\uff0c\u6216\u524d\u5f80\u94f6\u4f01\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u9875\u9762\uff0c\u70b9\u51fb\u8054\u673a\u67e5\u8be2\u540e\u53ef\u67e5\u770b\u3002", (String)"ShowNewLogDetailPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
        BizTypeEnum bizTypeEnum = BizTypeEnum.getBizTypeEnumByName((String)bizName);
        if (CollectionUtil.isEmpty(logInfos) && !bizTypeEnum.isNeedBizLog()) {
            if ("bussiness_bank".equalsIgnoreCase(logType)) {
                return tips_business_bank;
            }
            if ("bussiness_response".equalsIgnoreCase(logType)) {
                return tips_business_response;
            }
            return this.formatViewSimple(logInfos);
        }
        return this.formatViewSimple(logInfos);
    }

    private String formatViewSimple(List<LogInfo> logInfos) {
        StringBuilder stringBuilder = new StringBuilder();
        if (logInfos != null) {
            for (LogInfo info : logInfos) {
                stringBuilder.append(this.transFormat(info.getMessage()));
                stringBuilder.append("\r\n");
            }
            if (StringUtils.isEmpty(stringBuilder.toString())) {
                return MultiLang.getDataEmptyTip();
            }
            return stringBuilder.toString();
        }
        return MultiLang.getDataEmptyTip();
    }

    private String transFormat(String str) {
        if (StringUtil.isNil(str)) {
            return "-";
        }
        return str;
    }

    public List<LogInfo> getBizLog(String logger_batch_no, String logger_detail_no, String logger_bank_no, String bussiness_type, String bizName) {
        QFilter filter1;
        LogORM logORM = LogORM.create();
        ArrayList<QFilter> list = new ArrayList<QFilter>(1);
        QFilter filter = QFilter.of((String)"logger_batch_no = ?", (Object[])new Object[]{logger_batch_no});
        list.add(filter);
        if (StringUtils.isNotEmpty(logger_detail_no)) {
            filter1 = QFilter.of((String)"logger_detail_no = ?", (Object[])new Object[]{logger_detail_no});
            list.add(filter1);
        }
        if (StringUtils.isNotEmpty(logger_bank_no)) {
            filter1 = QFilter.of((String)"logger_bank_no = ?", (Object[])new Object[]{logger_bank_no});
            list.add(filter1);
        }
        if (StringUtils.isNotEmpty(bussiness_type)) {
            filter1 = QFilter.of((String)"logger_type = ?", (Object[])new Object[]{bussiness_type});
            list.add(filter1);
        }
        if (StringUtils.isNotEmpty(bizName)) {
            filter1 = QFilter.of((String)"biz_name = ?", (Object[])new Object[]{bizName});
            list.add(filter1);
        }
        list.toArray(new QFilter[list.size()]);
        DataSet ds = logORM.queryDataSet("aqap_biz_log", this.SELECT_ALL_PROPERTIES_DETAIL, list.toArray(new QFilter[list.size()]), 10000, 0).orderBy(new String[]{"biz_seq asc", "dt_query asc"});
        ArrayList<LogInfo> logInfoList = new ArrayList<LogInfo>(1);
        while (ds.hasNext()) {
            Row row = ds.next();
            LogInfo info = new LogInfo();
            String msg = row.get(0).toString();
            info.setMessage(msg);
            if (!ObjectUtils.isEmpty((Object)row.get(3)) && "1".equals(row.get(3).toString())) {
                try {
                    msg = StringCompressor.decompressString((String)msg);
                    info.setMessage(msg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            logInfoList.add(info);
        }
        return logInfoList;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String subTabKey = tabSelectEvent.getTabKey();
        String logger_bank_no = this.getPageCache().get("eb_bankNewLogDetailPlugin_logger_bank_no");
        String logger_batch_no = this.getPageCache().get("eb_bankNewLogDetailPlugin_logger_batch_no");
        String logger_detail_no = this.getPageCache().get("eb_bankNewLogDetailPlugin_logger_detail_no");
        String biz_name = this.getPageCache().get("eb_bankNewLogDetailPlugin_biz_name");
        List<LogInfo> logInfos = null;
        if (StringUtils.equals(subTabKey, "tabpageap1")) {
            String bussiness_request = this.getPageCache().get("eb_bankNewLogDetailPlugin_bussiness_request");
            if (StringUtils.isEmpty(bussiness_request)) {
                logInfos = BusinessTypeUtil.INSTANCE.isSynBusiness(biz_name) ? this.getBizLog(logger_batch_no, null, logger_bank_no, "bussiness_request", biz_name) : this.getBizLog(logger_batch_no, logger_detail_no, logger_bank_no, "bussiness_request", null);
                bussiness_request = this.formatViewSimple(logInfos);
                this.getPageCache().put("eb_bankNewLogDetailPlugin_bussiness_request", bussiness_request);
            }
            this.getModel().setValue("bussiness_request", (Object)bussiness_request);
        } else if (StringUtils.equals(subTabKey, "tabpageap2")) {
            String bussiness_response = this.getPageCache().get("eb_bankNewLogDetailPlugin_bussiness_response");
            if (StringUtils.isEmpty(bussiness_response)) {
                logInfos = BusinessTypeUtil.INSTANCE.isSynBusiness(biz_name) ? this.getBizLog(logger_batch_no, null, logger_bank_no, "bussiness_response", biz_name) : this.getBizLog(logger_batch_no, null, logger_bank_no, "bussiness_response", null);
                bussiness_response = this.formatViewSimple(logInfos, biz_name, "bussiness_response");
                this.getPageCache().put("eb_bankNewLogDetailPlugin_bussiness_response", bussiness_response);
            }
            this.getModel().setValue("bussiness_response", (Object)bussiness_response);
        } else if (StringUtils.equals(subTabKey, "tabpageap3")) {
            String bank_log = this.getPageCache().get("eb_bankNewLogDetailPlugin_bank_log");
            if (StringUtils.isEmpty(bank_log)) {
                logInfos = this.getBizLog(logger_batch_no, logger_detail_no, logger_bank_no, "bussiness_bank", null);
                bank_log = this.formatView(logInfos, biz_name, "bussiness_bank");
                this.getPageCache().put("eb_bankNewLogDetailPlugin_bank_log", bank_log);
            }
            this.getModel().setValue("bank_log", (Object)bank_log);
        } else if (StringUtils.equals(subTabKey, "tabpageap4")) {
            String other_log = this.getPageCache().get("eb_bankNewLogDetailPlugin_other_log");
            if (StringUtils.isEmpty(other_log)) {
                logInfos = this.getBizLog(logger_batch_no, null, logger_bank_no, "bussiness_process", null);
                other_log = this.formatView(logInfos);
                this.getPageCache().put("eb_bankNewLogDetailPlugin_other_log", other_log);
            }
            this.getModel().setValue("other_log", (Object)other_log);
        } else if (StringUtils.equals(subTabKey, "tabpageap5")) {
            String bussiness_request_pay = this.getPageCache().get("eb_bankNewLogDetailPlugin_bussiness_request_pay");
            if (StringUtils.isEmpty(bussiness_request_pay)) {
                logInfos = this.getBizLog(logger_batch_no, null, null, "bussiness_request", ShowNewLogDetailPlugin.getBussiness(biz_name));
                bussiness_request_pay = this.formatView(logInfos);
                this.getPageCache().put("eb_bankNewLogDetailPlugin_bussiness_request_pay", bussiness_request_pay);
            }
            this.getModel().setValue("bussiness_request_pay", (Object)bussiness_request_pay);
        } else if (StringUtils.equals(subTabKey, "tabpageap6")) {
            String bussiness_response_pay = this.getPageCache().get("eb_bankNewLogDetailPlugin_bussiness_response_pay");
            if (StringUtils.isEmpty(bussiness_response_pay)) {
                logInfos = this.getBizLog(logger_batch_no, null, null, "bussiness_response", ShowNewLogDetailPlugin.getBussiness(biz_name));
                bussiness_response_pay = this.formatView(logInfos, biz_name, "bussiness_response");
                this.getPageCache().put("eb_bankNewLogDetailPlugin_bussiness_response_pay", bussiness_response_pay);
            }
            this.getModel().setValue("bussiness_response_pay", (Object)bussiness_response_pay);
        } else if (StringUtils.equals(subTabKey, "tabpageap7")) {
            String bank_log_pay = this.getPageCache().get("eb_bankNewLogDetailPlugin_bank_log_pay");
            if (StringUtils.isEmpty(bank_log_pay)) {
                logInfos = this.getBizLog(logger_batch_no, logger_detail_no, null, "bussiness_bank", ShowNewLogDetailPlugin.getBussiness(biz_name));
                bank_log_pay = this.formatView(logInfos, biz_name, "bussiness_bank");
                this.getPageCache().put("eb_bankNewLogDetailPlugin_bank_log_pay", bank_log_pay);
            }
            this.getModel().setValue("bank_log_pay", (Object)bank_log_pay);
        } else if (StringUtils.equals(subTabKey, "tabpageap8")) {
            String other_log_pay = this.getPageCache().get("eb_bankNewLogDetailPlugin_other_log_pay");
            if (StringUtils.isEmpty(other_log_pay)) {
                logInfos = this.getBizLog(logger_batch_no, null, null, "bussiness_process", ShowNewLogDetailPlugin.getBussiness(biz_name));
                other_log_pay = this.formatView(logInfos);
                this.getPageCache().put("eb_bankNewLogDetailPlugin_other_log_pay", other_log_pay);
            }
            this.getModel().setValue("other_log_pay", (Object)other_log_pay);
        }
    }

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public static String getBussiness(String bizName) {
        return BusinessTypeUtil.INSTANCE.getBusinessType(bizName);
    }
}

