/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.repository;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.annotation.Component;

@Component
public class EbcBankLoginRepository {
    private static final String ENTITY_NAME = "aqap_bank_login";
    private static final String SELECT_PROPERTIES = "id, number, name, enable, config_type";

    public String getBankVersionByBankLoginID(Long bankLoginID) {
        String bankLoginKey = "number";
        DynamicObjectCollection datas = QueryServiceHelper.query((String)ENTITY_NAME, (String)bankLoginKey, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bankLoginID)});
        if (datas != null && datas.size() > 0) {
            String bankLogin = (String)((DynamicObject)datas.get(0)).get(bankLoginKey);
            int index = bankLogin.lastIndexOf("-");
            return bankLogin.substring(0, index);
        }
        return "";
    }

    public String getBankLoginNumberByID(Long ID2) {
        String bankLoginKey = "number";
        DynamicObjectCollection datas = QueryServiceHelper.query((String)ENTITY_NAME, (String)bankLoginKey, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ID2)});
        if (datas != null && datas.size() > 0) {
            String bankLogin = (String)((DynamicObject)datas.get(0)).get(bankLoginKey);
            int index = bankLogin.lastIndexOf("-");
            return bankLogin.substring(index + 1);
        }
        return "";
    }

    public boolean exitsBankLoginByBankVersion(String bankVersion) {
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("group.number", "=", (Object)bankVersion), new QFilter("enable", "=", (Object)"1")});
    }

    public boolean exitsBankLogin(String bankLoginID) {
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bankLoginID)});
    }

    public DynamicObject getBankLoginByBankLoginID(String bankLoginID) {
        return BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)SELECT_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bankLoginID)});
    }

    public DynamicObject[] getEnableBankLoginByBankVersionID(String bankVersionID) {
        return BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)SELECT_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("group.number", "=", (Object)bankVersionID), new QFilter("enable", "=", (Object)"1")});
    }

    public List<String> getBankLoginIDs(DynamicObject[] dynamicObjects) {
        ArrayList<String> result = new ArrayList<String>(16);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                result.add(dynamicObject.getString("number"));
            }
        }
        return result;
    }

    public List<String> getEnableMasterBankLoginIDsByBankVersionID(String bankVersionID) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("group.number", "=", (Object)bankVersionID), new QFilter("enable", "=", (Object)"1"), new QFilter("config_type", "=", (Object)"0")});
        return this.getBankLoginIDs((DynamicObject[])dynamicObjects.toArray((Object[])new DynamicObject[0]));
    }
}

