/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.util;

import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;

public class StringUtil {
    public static final int PAD_STYLE_LEFT = 1;
    public static final int PAD_STYLE_RIGTH = 2;
    public static final int PAD_STYLE_BOTH = 3;
    private static final char[] BASE_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".toCharArray();
    private static final Pattern KSM_ORDER_NUMBER_PATTERN = Pattern.compile("R20\\d{2}(0[1-9]|1[0-2])([0-2]\\d|3[0-1])-\\d{4}");

    public static boolean isNil(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotNil(String string) {
        return !StringUtil.isNil(string);
    }

    public static boolean isNil(Collection<String> strings) {
        return strings == null || strings.size() == 0;
    }

    public static boolean isNil(String[] strings) {
        return strings == null || strings.length == 0;
    }

    public static boolean isNotNil(String[] strings) {
        return !StringUtil.isNil(strings);
    }

    public static boolean isNotNil(Collection<String> strings) {
        return !StringUtil.isNil(strings);
    }

    public static List<String> createList(String ... strings) {
        ArrayList<String> list = new ArrayList<String>(16);
        for (int i = 0; i < strings.length; ++i) {
            list.add(strings[i]);
        }
        return list;
    }

    public static String[] createArray(List<String> strings) {
        String[] array = new String[strings.size()];
        for (int i = 0; i < strings.size(); ++i) {
            array[i] = strings.get(i);
        }
        return array;
    }

    public static String trim(String string) {
        if (string == null) {
            return string;
        }
        return string.trim();
    }

    public static boolean isInStrings(String target, String ... conditions) {
        for (String condition : conditions) {
            if (!target.equalsIgnoreCase(condition)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumber(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher match = pattern.matcher(str);
        return match.matches();
    }

    public static String subString(String str, int length) {
        if (StringUtil.isNil(str) || length <= 0) {
            return str;
        }
        return str.length() < length ? str : str.substring(0, length);
    }

    public static String subStringHTML(String param, int length, String end) {
        StringBuilder result = new StringBuilder();
        int n = 0;
        boolean isCode = false;
        boolean isHTML = false;
        for (int i = 0; i < param.length(); ++i) {
            char temp = param.charAt(i);
            if (temp == '<') {
                isCode = true;
            } else if (temp == '&') {
                isHTML = true;
            } else if (temp == '>' && isCode) {
                --n;
                isCode = false;
            } else if (temp == ';' && isHTML) {
                isHTML = false;
            }
            if (!isCode && !isHTML) {
                ++n;
                if ((temp + "").getBytes().length > 1) {
                    ++n;
                }
            }
            result.append(temp);
            if (n >= length) break;
        }
        result.append(end);
        String temp_result = result.toString().replaceAll("(>)[^<>]*(<?)", "$1$2");
        temp_result = temp_result.replaceAll("</?(AREA|BASE|BASEFONT|BODY|BR|COL|COLGROUP|DD|DT|FRAME|HEAD|HR|HTML|IMG|INPUT|ISINDEX|LI|LINK|META|OPTION|P|PARAM|TBODY|TD|TFOOT|TH|THEAD|TR|area|base|basefont|body|br|col|colgroup|dd|dt|frame|head|hr|html|img|input|isindex|li|link|meta|option|p|param|tbody|td|tfoot|th|thead|tr)[^<>]*/?>", "");
        temp_result = temp_result.replaceAll("<([a-zA-Z]+)[^<>]*>(.*?)</\\1>", "$2");
        Pattern p = Pattern.compile("<([a-zA-Z]+)[^<>]*>");
        Matcher m = p.matcher(temp_result);
        ArrayList<String> endHTML = new ArrayList<String>(16);
        while (m.find()) {
            endHTML.add(m.group(1));
        }
        for (int i = endHTML.size() - 1; i >= 0; --i) {
            result.append("</");
            result.append(endHTML.get(i));
            result.append(">");
        }
        return result.toString();
    }

    public static String limitStringByBytes(String value, int len) {
        if (StringUtil.isNil(value) || len <= 0) {
            return value;
        }
        if (value.getBytes().length <= len) {
            return value;
        }
        return new String(value.getBytes(), 0, len);
    }

    public static boolean validStringByBytes(String value, int len) {
        if (StringUtil.isNil(value) || len <= 0) {
            return true;
        }
        return value.getBytes().length <= len;
    }

    public static String blankWhenNull(String str) {
        return str == null ? "" : str;
    }

    public static String dashWhenNull(String str) {
        return str == null || "".equalsIgnoreCase(str.trim()) ? "\u2014\u2014" : str;
    }

    public static String getStringAfter(String s, String after) {
        int beginIndex = s.indexOf(after);
        if (s.length() == beginIndex + 1 || beginIndex == -1) {
            return "";
        }
        return s.substring(beginIndex + 1);
    }

    public static String right(String s, int length) {
        if (s == null) {
            return null;
        }
        assert (length > 0) : "length must greater than zero";
        if (s.length() <= length) {
            return s;
        }
        return s.substring(s.length() - length, s.length());
    }

    public static String listToString(List<String> productTagList, String split) {
        if (productTagList == null || productTagList.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String r = "";
        for (String item : productTagList) {
            if (r.length() == 0) {
                sb.append(item);
            } else if (item != null && item.length() > 0) {
                sb.append(split);
                sb.append(item);
            }
            r = sb.toString();
        }
        return r;
    }

    public static String listToString(List<String> productTagList) {
        return StringUtil.listToString(productTagList, ",");
    }

    public static boolean isNullOrEmpty(String str) {
        return null == str || 0 == str.trim().length();
    }

    public static String pad(String str, String padStr, int padTimes, int padStyle) {
        assert (str != null) : ResManager.loadKDString((String)"\u586b\u5145\u76ee\u6807\u4e3a\u7a7a", (String)"StringUtil_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
        assert (StringUtil.isNotNil(padStr)) : ResManager.loadKDString((String)"\u586b\u5145\u5b57\u7b26\u4e32\u4e3a\u7a7a\u3002", (String)"StringUtil_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
        assert (padTimes >= 0) : ResManager.loadKDString((String)"\u586b\u5145\u6b21\u6570\u5c0f\u4e8e0\u3002", (String)"StringUtil_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
        String actualPadStr = "";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < padTimes; ++i) {
            sb.append(padStr);
        }
        actualPadStr = sb.toString();
        if (1 == padStyle) {
            return actualPadStr + str;
        }
        if (2 == padStyle) {
            return str + actualPadStr;
        }
        if (3 == padStyle) {
            return actualPadStr + str + actualPadStr;
        }
        assert (false) : ResManager.loadKDString((String)"\u4e0d\u80fd\u8bc6\u522b\u586b\u5145\u6a21\u5f0f\u3002", (String)"StringUtil_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
        return str;
    }

    public static String pad(String str, int padTimes) {
        return StringUtil.pad(str, " ", padTimes, 3);
    }

    public static List<String> partition(String s, int len) {
        ArrayList<String> ss = new ArrayList<String>(1);
        if (s.length() > len) {
            do {
                ss.add(s.substring(0, len));
            } while ((s = s.substring(len)).length() > len);
        }
        ss.add(s);
        return ss;
    }

    public static String replaceComma(String str) {
        if (StringUtil.isNil(str)) {
            return str;
        }
        return str.replace(",", "\uff0c");
    }

    public static String[] split(String originalString, int splitByteLength) {
        ArrayList<String> vector = new ArrayList<String>();
        String strText = "";
        byte[] arrByte = null;
        int intStartIndex = 0;
        int intEndIndex = 0;
        int index = 0;
        int fixCount = 0;
        String[] arrReturn = null;
        if (originalString == null) {
            return new String[0];
        }
        if (originalString.equalsIgnoreCase("")) {
            return new String[0];
        }
        if (originalString.trim().equalsIgnoreCase("")) {
            return new String[]{""};
        }
        if (splitByteLength <= 1) {
            return new String[]{originalString};
        }
        arrByte = originalString.getBytes();
        intEndIndex = 0;
        while (true) {
            intStartIndex = intEndIndex;
            intEndIndex = intStartIndex + splitByteLength;
            if (intStartIndex >= arrByte.length) break;
            if (intEndIndex > arrByte.length) {
                intEndIndex = arrByte.length;
                strText = new String(arrByte, intStartIndex, intEndIndex - intStartIndex);
                vector.add(strText);
                break;
            }
            fixCount = 0;
            strText = new String(arrByte, intStartIndex, intEndIndex - intStartIndex);
            byte[] bytes = strText.getBytes();
            for (index = intEndIndex - 1; index >= intStartIndex && arrByte[index] != bytes[index - intStartIndex]; --index) {
                ++fixCount;
            }
            if (fixCount > 0) {
                if (fixCount >= intEndIndex) {
                    fixCount = 0;
                }
                strText = new String(arrByte, intStartIndex, (intEndIndex -= fixCount) - intStartIndex);
            }
            vector.add(strText);
        }
        arrReturn = new String[vector.size()];
        vector.toArray(arrReturn);
        return arrReturn;
    }

    public static String arrayToString(Object[] list, String splitStr) {
        if (list == null) {
            return "";
        }
        String row = "";
        for (int i = 0; i < list.length; ++i) {
            row = row + (list[i] == null ? splitStr : list[i] + splitStr);
        }
        row = row.substring(0, row.length() - splitStr.length());
        return row;
    }

    public static String objToStr(Object obj) {
        return obj == null ? "" : String.valueOf(obj);
    }

    public static String[] splitNoteNo(String noteNo) {
        if (noteNo == null) {
            noteNo = "";
        }
        String[] invoiceInfo = new String[2];
        if (noteNo.contains("-")) {
            invoiceInfo[0] = noteNo.split("-")[0];
            invoiceInfo[1] = noteNo.split("-")[1];
        } else {
            invoiceInfo[0] = "";
            invoiceInfo[1] = noteNo;
        }
        return invoiceInfo;
    }

    public static String dealNullAndTrimString(String str) {
        if (str == null || str.equalsIgnoreCase("")) {
            return "";
        }
        return str.trim();
    }

    public static List<String> split(String str) {
        return StringUtil.split(str, ",");
    }

    public static List<String> split(String str, String regex) {
        String[] arr;
        ArrayList<String> list = new ArrayList<String>(16);
        if (StringUtil.isNil(str)) {
            return list;
        }
        if (StringUtil.isNil(regex)) {
            list.add(str);
            return list;
        }
        for (String a : arr = str.split(regex)) {
            if (StringUtil.isNil(a.trim())) continue;
            list.add(a.trim());
        }
        return list;
    }

    public static boolean isEmail(String email) {
        String regex = "\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(email);
        return m.find();
    }

    public static boolean isMobileNO(String mobiles) {
        Pattern p = Pattern.compile("^((13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$");
        Matcher m = p.matcher(mobiles);
        return m.matches();
    }

    public static String convertBigDecimalToString(BigDecimal value) {
        if (value == null) {
            return "0.00";
        }
        value = value.setScale(2, 4);
        return value.toString();
    }

    public static boolean equals(String oldValue, String newValue) {
        if (oldValue == null) {
            return newValue == null ? true : newValue.equalsIgnoreCase(oldValue);
        }
        return oldValue.equalsIgnoreCase(newValue);
    }

    public static String replaceSpecialtyStr(String str, String pattern, String replace) {
        if (StringUtil.isNil(str)) {
            return null;
        }
        if (StringUtil.isNil(pattern)) {
            pattern = "\\s*|\t|\r|\n";
        }
        if (StringUtil.isNil(replace)) {
            replace = "";
        }
        return Pattern.compile(pattern).matcher(str).replaceAll(replace);
    }

    public static String replaceSpecialtyStr(String str) {
        return StringUtil.replaceSpecialtyStr(str, null, null);
    }

    public static String replaceExtraSpace(String str) {
        if ((str = str.replaceAll("\r+|\n+|\t+", " ").replaceAll(" +", " ")).startsWith(" ")) {
            str = str.substring(1);
        }
        if (str.endsWith(" ")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String obj2Str(Object o) {
        return o == null ? "" : o.toString();
    }

    public static boolean equalsIgnoreCase(String srcStr, String targetStr) {
        if (srcStr == null && targetStr == null) {
            return false;
        }
        if (srcStr != null) {
            return srcStr.equalsIgnoreCase(targetStr);
        }
        return targetStr.equalsIgnoreCase(srcStr);
    }

    public static String createNonceStr() {
        int length = 8;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int index = new SecureRandom().nextInt(BASE_CHARS.length);
            if (index % 2 == 0) {
                builder.append(Character.toLowerCase(BASE_CHARS[index]));
                continue;
            }
            builder.append(BASE_CHARS[index]);
        }
        return builder.toString();
    }

    public static boolean isValidFeedbackNumber(String feedbackNumber) {
        return KSM_ORDER_NUMBER_PATTERN.matcher(feedbackNumber).matches();
    }
}

