/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.service.payment;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bosh.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bosh.dc.service.login.LoginAndOut;
import kd.ebg.aqap.banks.bosh.dc.service.payment.PayTypeHelper;
import kd.ebg.aqap.banks.bosh.dc.service.payment.QueryPaymentImpl;
import kd.ebg.aqap.banks.bosh.dc.service.sign.SignHelper;
import kd.ebg.aqap.banks.bosh.dc.utils.BOSH_URLEncode;
import kd.ebg.aqap.banks.bosh.dc.utils.CommonUtil;
import kd.ebg.aqap.banks.bosh.dc.utils.Packer;
import kd.ebg.aqap.banks.bosh.dc.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0a\u6d77\u94f6\u884c\u4e0d\u652f\u6301\u6279\u91cf\u652f\u4ed8\u4e1a\u52a1\u3002", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element reqParam = new Element("ReqParam");
        logger.info("===\u662f\u5426\u540c\u884c===" + paymentInfo.getSameBank());
        logger.info("===\u662f\u5426\u540c\u57ce===" + paymentInfo.getSameCity());
        if (PayTypeHelper.isSameBank(paymentInfo)) {
            reqParam = PaymentImpl.pack4SameBank(reqParam, paymentInfo);
        } else {
            logger.info("===\u8de8\u884c\u652f\u4ed8===");
            if (PayTypeHelper.isSameCity(paymentInfo)) {
                logger.info("\u540c\u57ce\u652f\u4ed8");
                if (PayTypeHelper.isShangHaiSameCity(paymentInfo)) {
                    logger.info("\u540c\u57ce\u4e0a\u6d77\u652f\u4ed8");
                    logger.info("\u8d26\u6237\u6240\u5728===" + paymentInfo.getAccCity());
                    logger.info("\u6536\u6b3e\u4eba\u6240\u5728===" + paymentInfo.getIncomeCity());
                    reqParam = PaymentImpl.pack4DiffBankShangHaiSameCity(reqParam, paymentInfo);
                } else {
                    logger.info("\u975e\u540c\u57ce\u4e0a\u6d77\u652f\u4ed8");
                    reqParam = BankBusinessConfig.isSameCityToDiff() ? this.pack4DiffBankDiffCity(reqParam, paymentInfo) : PaymentImpl.pack4DiffBankSameCity(reqParam, paymentInfo);
                }
            } else {
                logger.info("\u5f02\u5730\u652f\u4ed8\uff08\u975e\u540c\u57ce\uff09");
                reqParam = this.pack4DiffBankDiffCity(reqParam, paymentInfo);
            }
        }
        String transferTypeOP = this.getTransferTypeOP(paymentInfo);
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
            JDomUtils.addChild((Element)reqParam, (String)"REMK", (String)Packer.addKd(paymentInfo));
        } else {
            String exp = paymentInfo.getExplanation();
            if (exp.length() > 40) {
                exp = exp.substring(0, 40);
            }
            JDomUtils.addChild((Element)reqParam, (String)"REMK", (String)exp);
        }
        JDomUtils.addChild((Element)reqParam, (String)"COSE", (String)"");
        String packAll = Packer.packAllInOne(paymentInfo.getBankBatchSeqID(), reqParam);
        packAll = packAll.replaceAll("\r", "").replaceAll("\n", "");
        String signedPayMsg = SignHelper.sign(packAll);
        String reqData = BOSH_URLEncode.encode(signedPayMsg);
        String session = LoginAndOut.login4GetSession();
        return Packer.getCommonBizReqData(session, transferTypeOP, reqData);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List infos = request.getPaymentInfos();
        BankResponse rsp = Parser.parseResponse(responseStr);
        if (!"0".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)"");
        }
        EBBankPayResponse response = new EBBankPayResponse();
        response.setPaymentInfos(infos);
        return response;
    }

    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1;
    }

    public boolean match(PaymentInfo info) {
        if ("pay".equalsIgnoreCase(info.getSubBizType())) {
            if (info.is2SameBank()) {
                return !BankBusinessConfig.isCrossUsedBySameBank();
            }
            return BankBusinessConfig.newOrOld();
        }
        return false;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    private Element pack4DiffBankDiffCity(Element reqParam, PaymentInfo paymentInfo) {
        JDomUtils.addChild((Element)reqParam, (String)"ACNO", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"OPAC", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"TRAM", (String)paymentInfo.getAmount().setScale(2, 4).toString());
        JDomUtils.addChild((Element)reqParam, (String)"EXNM", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)reqParam, (String)"NAME", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)reqParam, (String)"PBNO", (String)PayTypeHelper.getPBNO(paymentInfo));
        if (BankBusinessConfig.isDescToUse()) {
            JDomUtils.addChild((Element)reqParam, (String)"USAG", (String)CommonUtil.getSubString(paymentInfo.getExplanation(), 20));
        } else {
            JDomUtils.addChild((Element)reqParam, (String)"USAG", (String)paymentInfo.getUseCn());
        }
        return reqParam;
    }

    public static Element pack4DiffBankSameCity(Element reqParam, PaymentInfo paymentInfo) {
        JDomUtils.addChild((Element)reqParam, (String)"ACNO", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"OPAC", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"TRAM", (String)paymentInfo.getAmount().setScale(2, 4).toString());
        JDomUtils.addChild((Element)reqParam, (String)"EXNO", (String)PayTypeHelper.getEXNO(paymentInfo));
        JDomUtils.addChild((Element)reqParam, (String)"NAME", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)reqParam, (String)"EXNM", (String)paymentInfo.getIncomeBankName());
        if (BankBusinessConfig.isDescToUse()) {
            JDomUtils.addChild((Element)reqParam, (String)"USAG", (String)CommonUtil.getSubString(paymentInfo.getExplanation(), 20));
        } else {
            JDomUtils.addChild((Element)reqParam, (String)"USAG", (String)paymentInfo.getUseCn());
        }
        return reqParam;
    }

    public static Element pack4DiffBankShangHaiSameCity(Element reqParam, PaymentInfo paymentInfo) {
        JDomUtils.addChild((Element)reqParam, (String)"ACNO", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"BCCD", (String)PayTypeHelper.getBCCD(paymentInfo));
        JDomUtils.addChild((Element)reqParam, (String)"OPAC", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"NAME", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)reqParam, (String)"TRAM", (String)paymentInfo.getAmount().setScale(2, 4).toString());
        return reqParam;
    }

    public static Element pack4SameBank(Element reqParam, PaymentInfo paymentInfo) {
        JDomUtils.addChild((Element)reqParam, (String)"ACNO", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"OPAC", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"TRAM", (String)paymentInfo.getAmount().setScale(2, 4).toString());
        JDomUtils.addChild((Element)reqParam, (String)"NAME", (String)paymentInfo.getIncomeAccName());
        if (BankBusinessConfig.isDescToUse()) {
            JDomUtils.addChild((Element)reqParam, (String)"USAG", (String)CommonUtil.getSubString(paymentInfo.getExplanation(), 20));
        } else {
            JDomUtils.addChild((Element)reqParam, (String)"USAG", (String)paymentInfo.getUseCn());
        }
        return reqParam;
    }

    private String getTransferTypeOP(PaymentInfo paymentInfo) {
        if (PayTypeHelper.isSameBank(paymentInfo)) {
            if (paymentInfo.getIndividual().booleanValue()) {
                return "transferPersonal1_1Op";
            }
            return "transferInner1_1Op";
        }
        if (PayTypeHelper.isSameCity(paymentInfo)) {
            if (PayTypeHelper.isShangHaiSameCity(paymentInfo)) {
                return "transferSHCity1_1Op";
            }
            return "transferSameCity1_1Op";
        }
        return "transferDiffCity1_1Op";
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/CM/APIReqServlet");
        factory.setHttpHeader("User-Agent", "MSIE");
    }
}

