/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjb.dc.service.balance;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bjb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bjb.dc.service.PackerUtil;
import kd.ebg.aqap.banks.bjb.dc.service.ParserUtil;
import kd.ebg.aqap.banks.bjb.dc.service.login.LoginImpl;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CollectAccNoTodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(CollectAccNoTodayBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        Element root = new Element("BCCBEBankData");
        String opName = "CebankQueryAvailableBalanceOp";
        Element head = PackerUtil.createRequestHead(opName, Sequence.genSequence());
        Element param = JDomUtils.addChild((Element)head, (String)"ReqParam");
        JDomUtils.addChild((Element)param, (String)"accountNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)root, (Element)head);
        return PackerUtil.joinRequest(root, opName);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)"GB18030");
        BankResponse bankResponse = ParserUtil.parserRep(root);
        Preconditions.checkState((boolean)"0".equalsIgnoreCase(bankResponse.getResponseCode()), (Object)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u7801:%1$s,\u9519\u8bef\u4fe1\u606f:%2$s", (String)"CollectAccNoTodayBalanceImpl_0", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage()));
        Element opReq = JDomUtils.getChildElementNotNull((Element)root, (String)"opRep");
        Element element = JDomUtils.getChildElementNotNull((Element)opReq, (String)"opResult");
        BankAcnt acnt = new BankAcnt();
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        BalanceInfo balanceInfo = new BalanceInfo();
        String balance = JDomUtils.getChildTextNotNull((Element)element, (String)"balance");
        String availableBalance = JDomUtils.getChildTextNotNull((Element)element, (String)"AvailableBalance");
        String hisBalance = JDomUtils.getChildTextNotNull((Element)element, (String)"hisBal");
        log.info("\u8d26\u53f7\uff1a{} \u89e3\u6790\u5230\u7684\u5f53\u65e5\u4f59\u989d\uff1a{} \u53ef\u7528\u4f59\u989d\uff1a{} \u6628\u65e5\u4f59\u989d\uff1a{}", new Object[]{request.getAcnt().getAccNo(), balance, availableBalance, hisBalance});
        acnt.setAccNo(request.getAcnt().getAccNo());
        acnt.setAccName(JDomUtils.getChildTextNotNull((Element)element, (String)"acctName"));
        balance = balance.replaceAll(",", "");
        availableBalance = availableBalance.replaceAll(",", "");
        hisBalance = hisBalance.replaceAll(",", "");
        balanceInfo.setBankAcnt(acnt);
        balanceInfo.setBankCurrency(JDomUtils.getChildTextNotNull((Element)element, (String)"acctCur"));
        balanceInfo.setCurrentBalance(BigDecimalHelper.str2BigDecimalForBalance((String)balance, (Boolean)false));
        if (StringUtils.isNotEmpty((String)availableBalance)) {
            balanceInfo.setAvailableBalance(new BigDecimal(availableBalance));
        }
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        if (StringUtils.isNotEmpty((String)hisBalance)) {
            balanceInfo.setLastDayAvlBalance(new BigDecimal(hisBalance));
        }
        balanceInfos.add(balanceInfo);
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "CebankQueryAvailableBalanceOp";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d", (String)"CollectAccNoTodayBalanceImpl_1", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        LoginImpl.getInstance().configFactoryForSession(factory, false);
    }

    public boolean match(BankBalanceRequest request) {
        return BankBusinessConfig.isCollectAcnt(request.getAcnt().getAccNo());
    }
}

