/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zzb.dc.services.payment.salary;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zzb.dc.services.ProxyDownload;
import kd.ebg.aqap.banks.zzb.dc.services.ZZB_Packer;
import kd.ebg.aqap.banks.zzb.dc.services.ZZB_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;

public class SalaryQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 2000;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(BankPayRequest request) {
        String resp;
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        String fileJnINo = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"FileJnINo");
        ZZB_Packer.checkSynNo(fileJnINo);
        String fileName = request.getBankBatchSeqID();
        String uploadHead = ZZB_Parser.getUploadFilePackHead("AgentSalaryDetailQueryB2E", fileName, fileJnINo);
        RequestContextUtils.setRunningParam((String)"zzbQueryUri", (String)uploadHead);
        try {
            resp = ZZB_Parser.getUploadFilePackString(paymentInfo);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5411\u94f6\u884c\u524d\u7f6e\u673a\u53d1\u8d77\u4e0b\u8f7d\u6587\u4ef6\u8bf7\u6c42\u5f02\u5e38\uff0c%s\u3002", (String)"SalaryQueryPayImpl_7", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        return resp;
    }

    public EBBankPayResponse parse(BankPayRequest request, String resp) {
        String rspStr;
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String returnFileName = ZZB_Parser.getFileName(resp);
        try {
            rspStr = new ProxyDownload().doBiz(returnFileName);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5411\u91d1\u8776\u524d\u7f6e\u673a\u4ee3\u7406\u7a0b\u5e8f\u4e0b\u8f7d\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\u3002%s\u3002", (String)"SalaryQueryPayImpl_8", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        String[] lineStrings = rspStr.split("\n");
        for (int i = 1; i < lineStrings.length; ++i) {
            String[] tempStrings = lineStrings[i].split("\\|");
            String returnCode = tempStrings[4];
            if (StringUtils.isEmpty((String)tempStrings[3])) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u62a5\u6587\u683c\u5f0f\u9519\u8bef\uff0c\u91d1\u989d\u4e3a\u7a7a\u3002", (String)"SalaryQueryPayImpl_2", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]));
            }
            PaymentInfo payment = EBGBusinessUtils.selectPaymentInfo((List)request.getPaymentInfos(), (String)tempStrings[1], (BigDecimal)new BigDecimal(tempStrings[3]));
            if (payment == null) continue;
            if ("OK".equalsIgnoreCase(returnCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.SUCCESS, (String)"", (String)returnCode, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryQueryPayImpl_3", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]));
                continue;
            }
            if ("FL".equalsIgnoreCase(returnCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.FAIL, (String)"", (String)returnCode, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u5931\u8d25\u3002", (String)"SalaryQueryPayImpl_4", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]));
                continue;
            }
            if ("UC".equalsIgnoreCase(returnCode) || "BH".equalsIgnoreCase(returnCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.SUBMITED, (String)"", (String)returnCode, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryQueryPayImpl_5", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]));
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)returnCode, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u672a\u660e\u3002", (String)"SalaryQueryPayImpl_6", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(RequestContextUtils.getRunningParam((String)"zzbQueryUri"));
    }
}

