/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zzb.dc.services.payment.same;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zzb.dc.services.ZZB_Packer;
import kd.ebg.aqap.banks.zzb.dc.services.ZZB_Parser;
import kd.ebg.aqap.banks.zzb.dc.services.payment.same.SameBankQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SameBankPayImpl
extends AbstractPayImpl
implements IPay {
    private static final String TRANCODE = "B2EBankInnerTransfer";

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SameBankQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return TRANCODE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u652f\u4ed8", (String)"SameBankPayImpl_0", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) & paymentInfo.is2SameBank();
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u7b14\u4ed8\u6b3e\u3002", (String)"SameBankPayImpl_1", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)ZZB_Packer.buildHead(TRANCODE, paymentInfo.getBankBatchSeqId()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"PayerAcNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"TrsAmount", (String)paymentInfo.getAmount().toString());
        JDomUtils.addChild((Element)body, (String)"Remark", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"PayeeAcName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"PayeeAcNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"PayerCurrency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"TrsPassword", (String)"");
        return JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        List paymentInfos = request.getPaymentInfos();
        Element bank_root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = bank_root.getChild("Head");
        String mcJnlno = head.getChildText("McJnlno");
        PaymentInfoSysFiled.set((List)paymentInfos, (String)"McJnlno", (String)mcJnlno);
        Element body = bank_root.getChild("Body");
        BankResponse headRsp = ZZB_Parser.parserCommonInfo(bank_root);
        String bankStatus = headRsp.getResponseCode();
        String returnCode = JDomUtils.getChildText((Element)body, (String)"ProcessState");
        if ("000000".equals(bankStatus)) {
            if ("FL".equals(returnCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            }
        } else if ("validation.errormsg".equals(bankStatus)) {
            if (ZZB_Parser.isTimeOut(headRsp).booleanValue()) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eb2e/B2EBankInnerTransfer.do?";
        s = s + "userPassword=" + RequestContextUtils.getBankParameterValue((String)"userPassword") + "&SIGDATA=1&_locale=zh_CN";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
    }
}

