/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salarynew;

import java.math.BigDecimal;
import java.util.List;
import kd.ebg.aqap.banks.cmbc.dc.services.Constants;
import kd.ebg.aqap.banks.cmbc.dc.services.ExplanationUtil;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker
implements Constants {
    public static String packPay(List<PaymentInfo> paymentInfos) throws EBServiceException {
        boolean isReimed;
        PaymentInfo info = paymentInfos.get(0);
        Element root = Packer.createMessageWithHead("batchCostReimbNew");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)xdataBody, (String)"insId", (String)info.getBankBatchSeqId());
        JDomUtils.addChild((Element)xdataBody, (String)"PayerAcNo", (String)info.getAccNo());
        String type = "1";
        String usage = "4111";
        boolean bl = isReimed = info.getUseCN().contains(PropertiesConstants.getValue((String)"CLAIM_PAYMENT")) || !StringUtils.isEmpty((String)info.getExplanation()) && info.getExplanation().contains(PropertiesConstants.getValue((String)"CLAIM_PAYMENT"));
        if (isReimed) {
            type = "2";
            usage = ExplanationUtil.convertExplToBank(info.getExplanation(), info.getAmount());
        }
        JDomUtils.addChild((Element)xdataBody, (String)"payType", (String)type);
        JDomUtils.addChild((Element)xdataBody, (String)"payModel", (String)(info.is2Merge() ? "1" : "0"));
        JDomUtils.addChild((Element)xdataBody, (String)"totalRow", (String)("" + paymentInfos.size()));
        BigDecimal total = PayPacker.getTotalAmt(paymentInfos);
        JDomUtils.addChild((Element)xdataBody, (String)"totalAmt", (String)BigDecimalHelper.plain2((BigDecimal)total));
        JDomUtils.addChild((Element)xdataBody, (String)"fileContent", (String)PayPacker.getFileContent(paymentInfos));
        JDomUtils.addChild((Element)xdataBody, (String)"Usage", (String)usage);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    private static String getFileContent(List<PaymentInfo> infos) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < infos.size(); ++i) {
            PayPacker.app(buffer, infos.get(i).getBankDetailSeqId());
            PayPacker.app(buffer, infos.get(i).getIncomeAccNo());
            PayPacker.app(buffer, infos.get(i).getIncomeAccName());
            String explanation = infos.get(i).getExplanation();
            if (infos.get(i).is2Individual()) {
                String useCode = ExplanationUtil.convertExplToBank(infos.get(i).getExplanation(), infos.get(i).getAmount());
                PayPacker.app(buffer, useCode);
            } else {
                PayPacker.app(buffer, "");
            }
            PayPacker.app(buffer, PayPacker.formatString(explanation, 45));
            boolean sameBank = infos.get(i).is2SameBank();
            PayPacker.app(buffer, sameBank ? "0" : "1");
            PayPacker.app(buffer, "");
            PayPacker.app(buffer, infos.get(i).getIncomeBankName());
            if (sameBank) {
                PayPacker.app(buffer, "");
            } else {
                PayPacker.app(buffer, infos.get(i).getIncomeCnaps());
            }
            PayPacker.app(buffer, infos.get(i).getBankDetailSeqId());
            PayPacker.app(buffer, "");
            PayPacker.app(buffer, "");
            PayPacker.app(buffer, "");
            PayPacker.appEnd(buffer, BigDecimalHelper.plain2((BigDecimal)infos.get(i).getAmount()));
            if (i == infos.size() - 1) continue;
            String LINE_SEP = "^";
            buffer.append(LINE_SEP);
        }
        return buffer.toString();
    }

    private static void app(StringBuilder buffer, String field) {
        String FILED_SEP = "|";
        buffer.append(PayPacker.filter(field)).append(FILED_SEP);
    }

    private static void appEnd(StringBuilder buffer, String field) {
        buffer.append(PayPacker.filter(field));
    }

    private static String filter(String data) {
        if (StringUtils.isEmpty((String)data)) {
            return "";
        }
        data = StringUtils.replace((String)data, (String)"|", (String)"-");
        data = StringUtils.replace((String)data, (String)"^", (String)"-");
        return data;
    }

    private static BigDecimal getTotalAmt(List<PaymentInfo> paymentInfos) {
        BigDecimal total = BigDecimalHelper.ZERO;
        for (int i = 0; i < paymentInfos.size(); ++i) {
            total = BigDecimalHelper.add((BigDecimal)total, (BigDecimal)paymentInfos.get(i).getAmount());
        }
        return total;
    }

    private static String formatString(String str, int length) {
        if (!StringUtils.isEmpty((String)str) && str.length() > length) {
            str = str.substring(0, length);
        }
        return str;
    }
}

