/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.wzb.opa.services.balance;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.wzb.opa.util.GetStore;
import kd.ebg.aqap.banks.wzb.opa.util.MsgParser;
import kd.ebg.aqap.banks.wzb.opa.util.PackerUtil;
import kd.ebg.aqap.banks.wzb.opa.util.PostUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        JSONObject body = PackerUtil.getBody();
        body.put("payAcctNo", (Object)acnt.getAccNo());
        return JSONObject.toJSONString((Object)body);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        String result = MsgParser.getReceMsg(rspStr);
        JSONObject response = JSONObject.parseObject((String)result);
        JSONObject data = response.getJSONObject("data");
        String Balance = data.getString("payAcctBal");
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(rqst.getAcnt());
        String curCode = data.getString("curCode");
        if (!rqst.getBankCurrency().equals(curCode)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u5e01\u79cd\u548c\u94f6\u884c\u54cd\u5e94\u5e01\u79cd\u4e0d\u4e00\u81f4", (String)"BalanceImpl_2", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]));
        }
        balanceInfo.setBankCurrency(curCode);
        BigDecimal bal = new BigDecimal(Balance);
        balanceInfo.setCurrentBalance(bal);
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "queryeaccountbalance";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u4f59\u989d\u67e5\u8be2\u63a5\u53e3\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]);
    }

    public boolean async() {
        return false;
    }

    public EBBankBalanceResponse doBiz(BankBalanceRequest rqst) {
        String url = GetStore.getBaseUrl() + "/V1/P01502/S01/queryeaccountbalance";
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = PostUtil.sendMsg(rqstStr, url);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }
}

