/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.wzb.opa.services.payment.single;

import com.alibaba.fastjson.JSONObject;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.wzb.opa.util.GetStore;
import kd.ebg.aqap.banks.wzb.opa.util.MsgParser;
import kd.ebg.aqap.banks.wzb.opa.util.PackerUtil;
import kd.ebg.aqap.banks.wzb.opa.util.PostUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

public class QueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPaymentImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        JSONObject body = PackerUtil.getBody();
        body.put("busCode", (Object)"2");
        body.put("payAcctNo", (Object)info.getAccNo());
        body.put("startDate", (Object)info.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        body.put("orderNo", (Object)info.getBankBatchSeqID());
        return JSONObject.toJSONString((Object)body);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        if ("ebgprocess".equals(responseStr)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u53d1\u9001 \u94f6\u884c\u5904\u7406\u72b6\u6001\u3002", (String)"QueryPaymentImpl_1", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        String result = MsgParser.getReceMsg(responseStr);
        JSONObject response = JSONObject.parseObject((String)result);
        JSONObject data = response.getJSONObject("data");
        String dealStatus = data.getString("dealStatus");
        String failedReason = data.getString("failedReason");
        if ("0".equals(dealStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u53d1\u9001 \u94f6\u884c\u5904\u7406\u72b6\u6001\u3002", (String)"QueryPaymentImpl_1", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]), (String)"", (String)"");
        } else if ("1".equals(dealStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)dealStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPaymentImpl_2", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]));
        } else if ("2".equals(dealStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)dealStatus, (String)failedReason);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)dealStatus, (String)failedReason);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "selsingletrans";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u652f\u4ed8\u72b6\u6001\u67e5\u8be2", (String)"QueryPaymentImpl_3", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]);
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        String url = GetStore.getBaseUrl() + "/V1/P01507/S01/selsingletrans";
        try {
            String rqstStr = this.pack(request);
            String rspStr = PostUtil.sendMsg(rqstStr, url);
            return this.parse(request, rspStr);
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }
}

