/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.wzb.opa.util.sm2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import kd.ebg.aqap.banks.wzb.opa.util.sm2.SM2Const;
import kd.ebg.aqap.banks.wzb.opa.util.sm2.SM2KeyPair;
import kd.ebg.aqap.banks.wzb.opa.util.sm3.SM3Util;
import kd.ebg.egf.common.log.EBGLogger;
import org.bouncycastle.math.ec.ECPoint;

public class SM2Util
implements SM2Const {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(SM2Util.class);

    public static ECPoint generatePubKeyByPriKey(String priKeyHexString) {
        return SM2Util.generatePubKeyByPriKey(new BigInteger(priKeyHexString, 16));
    }

    public static ECPoint generatePubKeyByPriKey(BigInteger priKey) {
        SM2KeyPair keyPair = new SM2KeyPair(G.multiply(priKey).normalize(), priKey);
        return SM2Util.checkPublicKey(keyPair.getPublicKey()) ? keyPair.getPublicKey() : null;
    }

    public static BigInteger random(BigInteger max) {
        BigInteger r = new BigInteger(256, random);
        while (r.compareTo(max) >= 0) {
            r = new BigInteger(128, random);
        }
        return r;
    }

    public static boolean between(BigInteger param, BigInteger min, BigInteger max) {
        return param.compareTo(min) >= 0 && param.compareTo(max) < 0;
    }

    private static boolean checkPublicKey(ECPoint publicKey) {
        if (!publicKey.isInfinity()) {
            BigInteger x = publicKey.getXCoord().toBigInteger();
            BigInteger y = publicKey.getYCoord().toBigInteger();
            if (SM2Util.between(x, new BigInteger("0"), P) && SM2Util.between(y, new BigInteger("0"), P)) {
                BigInteger xResult = x.pow(3).add(a.multiply(x)).add(b).mod(P);
                BigInteger yResult = y.pow(2).mod(P);
                if (yResult.equals(xResult) && publicKey.multiply(N).isInfinity()) {
                    return true;
                }
            }
        }
        return false;
    }

    public static byte[] sm3hash(byte[] ... params) {
        byte[] res = SM3Util.sm3DigistAsBytes(SM2Util.join(params));
        return res;
    }

    public static byte[] join(byte[] ... params) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] res = null;
        try {
            for (int i = 0; i < params.length; ++i) {
                baos.write(params[i]);
            }
            res = baos.toByteArray();
        }
        catch (IOException var4) {
            logger.error(var4.getMessage());
        }
        return res;
    }

    public static byte[] ZA(byte[] ida, ECPoint aPublicKey) {
        int entlenA = ida.length * 8;
        byte[] ENTLA = new byte[]{(byte)(entlenA >> 8 & 0xFF), (byte)(entlenA & 0xFF)};
        byte[] ZA = SM2Util.sm3hash(ENTLA, ida, A.getEncoded(), B.getEncoded(), GX.getEncoded(), GY.getEncoded(), aPublicKey.getXCoord().getEncoded(), aPublicKey.getYCoord().getEncoded());
        return ZA;
    }

    public static String bigIntegerToHex(BigInteger bigInteger) {
        return SM2Util.bigIntegerToHex(bigInteger, 64);
    }

    public static String bigIntegerToHex(BigInteger bigInteger, int length) {
        byte[] bytes = new byte[length];
        byte[] hexBytes = bigInteger.toString(16).getBytes();
        for (int i = 0; i < length; ++i) {
            int position = hexBytes.length - i - 1;
            bytes[length - i - 1] = position < 0 ? 48 : hexBytes[position];
        }
        return new String(bytes);
    }
}

