/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.curandfixed.notice2cur;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class QueryNotify {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryNotify.class);
    private static QueryNotify instance = null;
    private boolean isFinished = false;

    public static QueryNotify getInstance() {
        if (instance == null) {
            return new QueryNotify();
        }
        return instance;
    }

    public boolean setNotifyID(BankCurAndFixedRequest bankCurAndFixedRequest) {
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)bankCurAndFixedRequest.getCafInfos().get(0);
        String notii = curAndFixedInfo.getNotifyId();
        this.isFinished = false;
        if (!StringUtils.isEmpty((String)notii) && !"cancelNotification".equalsIgnoreCase(bankCurAndFixedRequest.getHeader().getSubBizType())) {
            return true;
        }
        String str = this.pack(bankCurAndFixedRequest);
        String s = PostUtil.sendMsg(str);
        this.parse(bankCurAndFixedRequest, s);
        return this.isFinished;
    }

    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        String bizCode = "QueryNotify";
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.genSequence());
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        JSONObject ntsmaqryx = new JSONObject();
        ntsmaqryx.put("bbknbr", (Object)curAndFixedInfo.getFixedAcntBankNo());
        ntsmaqryx.put("accnbr", (Object)curAndFixedInfo.getFixedAccNo());
        Date date = Date.from(curAndFixedInfo.getTranDate().toLocalDate().atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
        ntsmaqryx.put("bgndat", (Object)DateUtil.formatDate((Date)date));
        ntsmaqryx.put("enddat", (Object)DateUtil.formatDate((Date)date));
        ntsmaqryx.put("infsts", (Object)"*");
        JSONArray array = new JSONArray();
        array.add((Object)ntsmaqryx);
        JSONObject body = new JSONObject();
        body.put("ntsmaqryx", (Object)array);
        JSONObject request = JsonUtil.getrequest(head, body);
        if (EBContext.getContext().isUnitTest()) {
            return "";
        }
        return MsgPacker.getSendMsg(request, logger, bizCode);
    }

    public void parse(BankCurAndFixedRequest bankCurAndFixedRequest, String str) {
        String receMsg = MsgParser.getReceMsg(str, logger);
        this.parse(receMsg, bankCurAndFixedRequest);
    }

    public void parse(String receMsg, BankCurAndFixedRequest bankCurAndFixedRequest) {
        List details = bankCurAndFixedRequest.getCafInfos();
        BankResponse response = MsgParser.getResponse(receMsg, logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"QueryNotify_4", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)receMsg);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntsmaqryz = body.getJSONArray("ntsmaqryz");
        if (ntsmaqryz != null && !ntsmaqryz.isEmpty()) {
            CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)details.get(0);
            JSONObject detail = ntsmaqryz.getJSONObject(0);
            String infseq = detail.getString("infseq");
            String expdat = detail.getString("expdat");
            String infsts = detail.getString("infsts");
            String inftxt = detail.getString("inftxt");
            if (StringUtils.isEmpty((String)infsts) || StringUtils.isEmpty((String)infseq)) {
                logger.info("\u672a\u6210\u529f\u83b7\u53d6\u901a\u77e5\u5e8f\u53f7");
                CAFUtil.setState((List)details, (CurAndFixedState)CurAndFixedState.SUBMITED, (String)ResManager.loadKDString((String)"<Check>\u5c1a\u672a\u83b7\u53d6\u8be5\u901a\u77e5\u7684\u901a\u77e5\u7f16\u53f7</Check>\u3002", (String)"QueryNotify_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)"", (String)"");
            } else if ("A".equalsIgnoreCase(infsts)) {
                logger.info("\u83b7\u53d6\u901a\u77e5\u5e8f\u53f7\u4e3a\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014>{}", (Object)infseq);
                curAndFixedInfo.setNotifyId(infseq);
                this.setFinished(true);
            } else if ("E".equalsIgnoreCase(infsts)) {
                CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.SUCCESS, (String)ResManager.loadKDString((String)"<Check>\u8be5\u7b14\u901a\u77e5\u5b58\u6b3e\u5df2\u5b8c\u6210\u652f\u53d6</Check>\u3002", (String)"QueryNotify_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)"", (String)inftxt);
            } else if ("C".equalsIgnoreCase(infsts)) {
                CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.NTS_CANCEL_FINISHED, (String)ResManager.loadKDString((String)"<Check>\u8be5\u901a\u77e5\u5df2\u53d6\u6d88</Check>\u3002", (String)"QueryNotify_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)"", (String)inftxt);
            } else {
                CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.FAIL, (String)("<Check>" + inftxt + "</Check>"), (String)"", (String)"");
            }
        }
        bankCurAndFixedRequest.setCafInfos(details);
    }

    public void setFinished(boolean finished) {
        this.isFinished = finished;
    }
}

