/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.curandfixed.notice2cur;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.service.areacode.AreaCodeImpl;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.currentandfixed.atomic.AbstractCAFImpl;
import kd.ebg.aqap.business.currentandfixed.atomic.ICurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class WithDrawNotiiImpl
extends AbstractCAFImpl
implements ICurAndFixed {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(WithDrawNotiiImpl.class);

    public int getBatchSize() {
        return 0;
    }

    public EBBankCurAndFixedResponse doBiz(BankCurAndFixedRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        String bizCode = "NTSMAWOP";
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.genSequence());
        BankAcnt acnt = bankCurAndFixedRequest.getHeader().getAcnt();
        JSONObject ntsmawopx = new JSONObject();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)bankCurAndFixedRequest.getCafInfos().get(0);
        String busmod = BankBusinessConfig.getCurAndNotiiBusMod(acnt.getAccNo());
        ntsmawopx.put("buscod", (Object)"N08020");
        ntsmawopx.put("busmod", (Object)busmod);
        String areaCode = AreaCodeImpl.getInstance().getAreaCode(acnt);
        ntsmawopx.put("bbknbr", (Object)areaCode);
        ntsmawopx.put("accnbr", (Object)curAndFixedInfo.getAccNo());
        ntsmawopx.put("fixbbk", (Object)curAndFixedInfo.getFixedAcntBankNo());
        ntsmawopx.put("fixacc", (Object)curAndFixedInfo.getFixedAccNo());
        if (StringUtils.isEmpty((String)curAndFixedInfo.getNotifyId())) {
            ntsmawopx.put("infflg", (Object)"N");
        } else {
            ntsmawopx.put("infflg", (Object)"Y");
            ntsmawopx.put("fixacc", (Object)curAndFixedInfo.getNotifyId());
        }
        ntsmawopx.put("ccynbr", (Object)curAndFixedInfo.getCurrency());
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal add = amount.add(new BigDecimal(curAndFixedInfo.getAmount()));
        if (add.compareTo(new BigDecimal("500000")) < 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"<Check>\u652f\u53d6\u901a\u77e5\u8d26\u6237\u91d1\u989d\u5e94\u5927\u4e8e\u7b49\u4e8e500000</Check>\u3002", (String)"WithDrawNotiiImpl_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        ntsmawopx.put("trsamt", (Object)curAndFixedInfo.getAmount());
        ntsmawopx.put("yurref", (Object)curAndFixedInfo.getBatchSeqId());
        JSONArray array = new JSONArray();
        array.add((Object)ntsmawopx);
        JSONObject body = new JSONObject();
        body.put("ntsmawopx", (Object)array);
        JSONObject request = JsonUtil.getrequest(head, body);
        if (EBContext.getContext().isUnitTest()) {
            return "";
        }
        return MsgPacker.getSendMsg(request, logger, bizCode);
    }

    public EBBankCurAndFixedResponse parse(BankCurAndFixedRequest bankCurAndFixedRequest, String s) {
        String res = MsgParser.getReceMsg(s, logger);
        return this.parse(res, bankCurAndFixedRequest);
    }

    public EBBankCurAndFixedResponse parse(String res, BankCurAndFixedRequest bankCurAndFixedRequest) {
        JSONObject object;
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        BankResponse response = MsgParser.getResponse(res, logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"WithDrawNotiiImpl_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject head = resp.getJSONObject("head");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntsmawopz = body.getJSONArray("ntsmawopz");
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        if (ntsmawopz != null && !ntsmawopz.isEmpty() && !(object = ntsmawopz.getJSONObject(0)).isEmpty()) {
            String infdat = object.getString("infdat");
            String expdat = object.getString("expdat");
            String actbal = object.getString("actbal");
            String intamt = object.getString("intamt");
            String taxamt = object.getString("taxamt");
            String reqnbr = object.getString("reqnbr");
            CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
            curAndFixedInfo.setEndDate(expdat);
            curAndFixedInfo.setEndIntDate(infdat);
            curAndFixedInfo.setAccBal(actbal);
            curAndFixedInfo.setFixActInt(intamt);
            curAndFixedInfo.setFixTaxInt(taxamt);
            curAndFixedInfo.setReqNbr(reqnbr);
        }
        ebBankCurAndFixedResponse.setDetails(bankCurAndFixedRequest.getCafInfos());
        return ebBankCurAndFixedResponse;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

