/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.payment;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.service.payment.BusModUtil;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;

public class BatchResultUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BatchResultUtil.class);

    public static String packSearch(PaymentInfo[] paymentInfos) throws EBServiceException {
        JSONObject ntagdinfy1 = new JSONObject();
        ntagdinfy1.put("reqnbr", (Object)PaymentInfoSysFiled.get((PaymentInfo)paymentInfos[0], (String)"reqnbr"));
        JSONObject body = new JSONObject();
        body.put("ntagdinfy1", (Object)ntagdinfy1);
        String bizCode = "NTAGDINF";
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.genSequence());
        JSONObject request = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(request, logger, bizCode);
    }

    public static void getBusMod(PaymentInfo[] paymentInfos) throws EBServiceException {
        BatchResultUtil.getBusMod(paymentInfos, false);
    }

    public static void getBusMod(PaymentInfo[] paymentInfos, boolean isAllFail) throws EBServiceException {
        String rqstStr = BatchResultUtil.packSearch(paymentInfos);
        String rspStr = PostUtil.sendMsg(rqstStr);
        BankResponse response = MsgParser.getResponse(rspStr = MsgParser.getReceMsg(rspStr, logger), logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"BatchResultUtil_7", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)rspStr);
        JSONObject resp = request.getJSONObject("response");
        JSONObject head = resp.getJSONObject("head");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntagcdtly1 = body.getJSONArray("ntagcdtly1");
        for (int i = 0; i < ntagcdtly1.size(); ++i) {
            JSONObject object = (JSONObject)ntagcdtly1.get(i);
            String trxseq = object.getString("trxseq");
            String stscod = object.getString("stscod");
            String errcod = object.getString("errcod");
            String errdsp = object.getString("errdsp");
            PaymentInfo payment = BatchResultUtil.selectPaymentInfo(paymentInfos, trxseq);
            if (isAllFail) {
                if (payment == null) continue;
                payment.setBankMsg(errdsp);
                continue;
            }
            if ("S".equals(stscod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"BatchResultUtil_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)stscod, (String)errdsp);
                continue;
            }
            if ("E".equals(stscod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"BatchResultUtil_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)errcod, (String)errdsp);
                continue;
            }
            if ("A".equals(stscod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"BatchResultUtil_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)errcod, (String)errdsp);
                continue;
            }
            if ("I".equals(stscod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u5f85\u590d\u6838", (String)"BatchResultUtil_4", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)errcod, (String)errdsp);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"BatchResultUtil_5", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)errcod, (String)errdsp);
        }
    }

    public static String getSerialNo(String no) {
        if (no.length() == 1) {
            return "0000000" + no;
        }
        if (no.length() == 2) {
            return "000000" + no;
        }
        if (no.length() == 3) {
            return "00000" + no;
        }
        if (no.length() == 4) {
            return "0000" + no;
        }
        if (no.length() == 5) {
            return "000" + no;
        }
        if (no.length() == 6) {
            return "00" + no;
        }
        if (no.length() == 7) {
            return "0" + no;
        }
        return no;
    }

    public static PaymentInfo selectPaymentInfo(PaymentInfo[] infos, String bankDetailSeqId) {
        for (int i = 0; i < infos.length; ++i) {
            String no = BusModUtil.getSerialNo(infos[i].getBankSerialNo());
            if (!no.equals(bankDetailSeqId)) continue;
            return infos[i];
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u4e5f\u8bb8\u8fd4\u56de\u4e86\u610f\u5916\u7684\u4ed8\u6b3e\u6307\u4ee4\u6d41\u6c34\u53f7:%s\u3002", (String)"BatchResultUtil_8", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), bankDetailSeqId);
        logger.warn(errorMsg);
        return null;
    }
}

