/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.payment.linkpay;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;

public class PayParser {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PayParser.class);

    public void parsePay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        if (rspStr.contains("ErrMsg")) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"PayParser_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)"", (String)rspStr);
        } else {
            String res = MsgParser.getReceMsg(rspStr, this.logger);
            this.parseLinkPay(paymentInfos, res);
        }
    }

    public void parseLinkPay(PaymentInfo[] paymentInfos, String res) throws EBServiceException {
        BankResponse response = MsgParser.getResponse(res, this.logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"PayParser_6", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject head = resp.getJSONObject("head");
        JSONObject body = resp.getJSONObject("body");
        JSONArray array = body.getJSONArray("ntoprrtnz");
        if (array != null && array.size() > 0) {
            JSONObject bb1payopz1 = array.getJSONObject(0);
            String reqSts = bb1payopz1.getString("reqsts");
            String rtnFlg = bb1payopz1.getString("rtnflg");
            if ("FIN".equals(reqSts) && "F".equals(rtnFlg)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PayParser_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayParser_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"PayParser_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"PayParser_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)res);
        }
    }
}

