/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.payment.salary;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.service.payment.BatchResultUtil;
import kd.ebg.aqap.banks.cmb.opa.service.payment.BusModUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;

public class QueryPayParser {
    EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayParser.class);

    public void parseQueryPay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        String res = MsgParser.getReceMsg(rspStr, this.logger);
        this.parse(paymentInfos, res);
    }

    public void parse(PaymentInfo[] paymentInfos, String res) throws EBServiceException {
        BankResponse response = MsgParser.getResponse(res, this.logger);
        if (!"SUC0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"QueryPayParser_14", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject head = resp.getJSONObject("head");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntagcinqz = body.getJSONArray("ntagcinqz");
        for (int i = 0; i < ntagcinqz.size(); ++i) {
            JSONObject object = (JSONObject)ntagcinqz.get(i);
            String reqsta = object.getString("reqsta");
            String rtnflg = object.getString("rtnflg");
            if ("FIN".equals(reqsta)) {
                if ("F".equals(rtnflg)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnflg, (String)ResManager.loadKDString((String)"\u6574\u6279\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_11", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
                    if (!BankBusinessConfig.isSalaryFailSearchMsg()) continue;
                    BatchResultUtil.getBusMod(paymentInfos, true);
                    continue;
                }
                if ("R".equals(rtnflg)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnflg, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25,\u4f01\u4e1a\u5ba1\u6279\u5426\u51b3", (String)"QueryPayParser_4", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
                    continue;
                }
                if ("D".equals(rtnflg)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnflg, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25,\u4f01\u4e1a\u8fc7\u671f\u4e0d\u5ba1\u6279", (String)"QueryPayParser_6", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
                    continue;
                }
                if ("C".equals(rtnflg)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnflg, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25,\u4f01\u4e1a\u64a4\u9500", (String)"QueryPayParser_5", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
                    continue;
                }
                if (!"S".equals(rtnflg)) continue;
                BatchResultUtil.getBusMod(paymentInfos);
                continue;
            }
            if (!"AUT".equals(reqsta) && !"NTE".equals(reqsta) && !"BNK".equals(reqsta)) continue;
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rtnflg, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayParser_8", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
    }

    public static PaymentInfo selectPaymentInfo(PaymentInfo[] infos, String bankDetailSeqId) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayParser.class);
        for (int i = 0; i < infos.length; ++i) {
            String no = BusModUtil.getSerialNo(infos[i].getBankSerialNo());
            if (!no.equalsIgnoreCase(bankDetailSeqId)) continue;
            return infos[i];
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u4e5f\u8bb8\u8fd4\u56de\u4e86\u610f\u5916\u7684\u4ed8\u6b3e\u6307\u4ee4\u6d41\u6c34\u53f7:%s\u3002", (String)"QueryPayParser_15", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), bankDetailSeqId);
        logger.warn(errorMsg);
        return null;
    }
}

