/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.util;

import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.SMUtil;
import kd.ebg.aqap.banks.cmb.opa.util.SignWithAES;
import kd.ebg.aqap.banks.cmb.opa.util.SignWithRSA;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class MsgPacker {
    public static String getSendMsg(JSONObject object, EBGLogger logger, String bizCode) {
        EBContext.getContext().setType("request");
        String orgi = JsonUtil.serialJsonOrdered(object);
        logger.info("\u539f\u59cb\u6570\u636e\uff1a" + orgi);
        if (BankBusinessConfig.isPreCloud()) {
            return MsgPacker.getFormParam(orgi, false, bizCode, logger);
        }
        boolean isSM = "SM".equalsIgnoreCase(RequestContextUtils.getBankParameterValue((String)"sign_type"));
        String signstr = isSM ? SMUtil.signUser(orgi) : SignWithRSA.encryptAES256Str(orgi);
        String content = "";
        if (!BankBusinessConfig.isSaasCloud()) {
            content = JsonUtil.getFinallyStr(object, signstr);
        } else {
            String plateFormSignStr = SMUtil.signKingdee(signstr);
            content = JsonUtil.getPlateFromFinallyStr(object, signstr, plateFormSignStr);
        }
        String result = isSM ? SMUtil.encrypt(content) : SignWithAES.encryptAES256Str(content);
        return MsgPacker.getFormParam(result, isSM, bizCode, logger);
    }

    private static String getFormParam(String param, boolean isSM, String bizCode, EBGLogger logger) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        String encoding = RequestContextUtils.getCharset();
        String loginName = RequestContextUtils.getBankParameterValue((String)"lgnnam");
        map.put("UID", loginName);
        if (BankBusinessConfig.isSaasCloud()) {
            map.put("INSPLAT", "KINGDEE");
        }
        if (isSM) {
            map.put("ALG", "SM");
        }
        if (StringUtils.isNotEmpty((String)bizCode)) {
            map.put("FUNCODE", bizCode);
        }
        try {
            map.put("DATA", URLEncoder.encode(param, encoding));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String result = MsgPacker.createLinkString(map);
        return result;
    }

    public static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder prestr = new StringBuilder();
        String eqs = "=";
        for (int i = 0; i < keys.size(); ++i) {
            String key = keys.get(i);
            String value = params.get(key);
            if (i == keys.size() - 1) {
                prestr.append(key).append(eqs).append(value);
                continue;
            }
            prestr.append(key).append(eqs).append(value).append("&");
        }
        return prestr.toString();
    }

    public static String string(String s) {
        return StringUtils.isEmpty((String)s) ? "" : s;
    }
}

