/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hlbrcb.cmp.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hlbrcb.cmp.utils.Packer;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        Element root = Packer.createRoot("100002");
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AcctNo", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"Currency", (String)bankBalanceRequest.getBankCurrency());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element head = root.getChild("Head");
        String respCode = head.getChildTextTrim("RspCode");
        String respInfo = head.getChildTextTrim("RspMsg");
        if (!"000000".equalsIgnoreCase(respCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u7801:%1$s\uff0c\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-hlbrcb-cmp", (Object[])new Object[0]), respCode, respInfo));
        }
        Element body = root.getChild("Body");
        String accNo = body.getChildTextTrim("AcctNo");
        String currency = body.getChildTextTrim("Currency");
        String balanceStr = body.getChildTextTrim("Balance");
        String availableBalanceStr = body.getChildTextTrim("AvailBal");
        BalanceInfo balance = new BalanceInfo();
        this.setCurrentBalance(balance, balanceStr.trim());
        this.setAvailableBalance(balance, availableBalanceStr.trim());
        this.logger.info("\u89e3\u6790\u5230\u8fd4\u56de\u7684'\u5e01\u79cd'\u4e3a" + currency);
        if ("01".equals(currency)) {
            currency = "CNY";
            this.logger.info("\u5728\u63d2\u4ef6\u4e2d\u7279\u6b8a\u5904\u7406\u5c06'\u5e01\u79cd'\u8f6c\u6362\u4e3a" + currency);
        }
        this.setBankAcnt(balance, bankBalanceRequest.getBankAcntList(), accNo);
        this.setBankCurrency(balance, currency);
        this.setBalanceDateTime(balance, LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "100002";
    }

    public String getBizDesc() {
        return null;
    }
}

