/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scnx.dc.services.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.scnx.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.scnx.dc.services.payment.allocation.AllocationPaymentImpl;
import kd.ebg.aqap.banks.scnx.dc.services.payment.group.PayImpl;
import kd.ebg.aqap.banks.scnx.dc.services.payment.inter.InterBankPaymentImpl;
import kd.ebg.aqap.banks.scnx.dc.services.payment.same.SameBankPaymentImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PretreatmentImpl
implements IPretreat {
    public void appendData(PaymentInfo paymentInfo) {
        paymentInfo = this.pretreatPaymentInfo(paymentInfo);
        BusiImplInfo busiImplInfo = this.getBusiImplInfo(paymentInfo);
        paymentInfo.setImplClassName(busiImplInfo.getImplName());
        paymentInfo.setQueryImplClassName(busiImplInfo.getQueryImplName());
        paymentInfo.setPackageKey(busiImplInfo.getPackageKey());
    }

    private PaymentInfo pretreatPaymentInfo(PaymentInfo paymentInfo) throws EBServiceException {
        return paymentInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        StringBuilder packageKey = new StringBuilder();
        packageKey.append(paymentInfo.getPackageKey());
        String subBizType = paymentInfo.getSubBizType();
        if ("pay".equals(paymentInfo.getSubBizType()) || "pay_for_salary".equals(paymentInfo.getSubBizType()) && !UseConvertor.isSalary((PaymentInfo)paymentInfo)) {
            if (BankBusinessConfig.isGroupChildAcnt(paymentInfo.getAccNo())) {
                busiImplInfo.setImplName(PayImpl.class.getName());
            } else if (!paymentInfo.is2SameBank()) {
                busiImplInfo.setImplName(InterBankPaymentImpl.class.getName());
            } else {
                busiImplInfo.setImplName(SameBankPaymentImpl.class.getName());
            }
        } else if ("pay_for_capital_allocation".equalsIgnoreCase(paymentInfo.getSubBizType())) {
            if (StringUtils.isNotEmpty((String)paymentInfo.getLinkpayType())) {
                if (!paymentInfo.is2SameBank()) throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8de8\u884c\u8054\u52a8\u652f\u4ed8\u3002", (String)"PretreatmentImpl_2", (String)"ebg-aqap-banks-scnx-dc", (Object[])new Object[0]), new Object[0]));
                busiImplInfo.setImplName(SameBankPaymentImpl.class.getName());
            } else {
                busiImplInfo.setImplName(AllocationPaymentImpl.class.getName());
            }
        } else {
            if (!"pay_for_linkpay".equalsIgnoreCase(paymentInfo.getSubBizType())) throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u8be5\u79cd\u4e1a\u52a1\u7c7b\u578b%1$s, \u8bf7\u68c0\u67e5\u8be5\u4e1a\u52a1\u7c7b\u578b\u662f\u5426\u6b63\u786e\u3002", (String)"PretreatmentImpl_1", (String)"ebg-aqap-banks-scnx-dc", (Object[])new Object[0]), subBizType));
            if (!paymentInfo.is2SameBank()) {
                busiImplInfo.setImplName(InterBankPaymentImpl.class.getName());
            } else {
                busiImplInfo.setImplName(SameBankPaymentImpl.class.getName());
            }
        }
        busiImplInfo.setPackageKey(packageKey.toString());
        busiImplInfo.appendNode("SubBizType=" + subBizType);
        busiImplInfo.appendNode(this.getMethodName());
        return busiImplInfo;
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        return null;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }
}

