/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scnx.dc.services.payment.same;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.scnx.dc.services.payment.CommonPayParser;
import kd.ebg.aqap.banks.scnx.dc.services.payment.QueryPaymentImpl;
import kd.ebg.aqap.banks.scnx.dc.services.utils.CommonPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SameBankPaymentImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml;charset=" + RequestContextUtils.getCharset());
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"exchangeUri"));
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = CommonPacker.packHeader(this.getBizCode(), paymentInfo.getBankDetailSeqId());
        Element body = JDomUtils.addChild((Element)root, (String)"BODY");
        JDomUtils.addChild((Element)body, (String)"PAY_PTY_ACCT_NO", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"PAY_PTY_ACCT_NM", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"CUR_CD", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"RCV_PTY_ACCT_NO", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"RCV_PTY_ACCT_NM", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"TX_AMT", (String)paymentInfo.getAmount().toString());
        JDomUtils.addChild((Element)body, (String)"TX_USAGE_COMNT", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"REMRK", (String)"");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        new CommonPayParser().parsePay(request, responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "TC002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u8d26", (String)"SameBankPaymentImpl_0", (String)"ebg-aqap-banks-scnx-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return ("pay".equals(paymentInfo.getSubBizType()) || "pay_for_salary".equals(paymentInfo.getSubBizType()) && !UseConvertor.isSalary((PaymentInfo)paymentInfo)) && paymentInfo.is2SameBank();
    }
}

