/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.payment.individual;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.services.PaymentInfosUtil;
import kd.ebg.aqap.banks.citic.dc.services.StatusCodeHelper;
import kd.ebg.aqap.banks.citic.dc.services.payment.AbstractBatchQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class IndividualQueryPayImpl
extends AbstractBatchQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 200;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLOTHDET";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5176\u4ed6\u4ee3\u4ed8\u660e\u7ec6\u67e5\u8be2", (String)"IndividualQueryPayImpl_0", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        Element root = JDomUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLOTHDET");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"clientID", (String)((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        String message = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        return message;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        String status = root.getChildText("status");
        String statusText = root.getChildText("statusText");
        if (!"AAAAAAA".equalsIgnoreCase(status)) {
            if (StatusCodeHelper.isDoingCode(status)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"IndividualQueryPayImpl_1", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (String)status, (String)statusText);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"IndividualQueryPayImpl_2", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (String)status, (String)statusText);
            }
            return new EBBankPayResponse(paymentInfos);
        }
        Element list = root.getChild("list");
        List rowList = list.getChildren("row");
        if (rowList == null || rowList.size() == 0) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"IndividualQueryPayImpl_2", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)" \u8fd4\u56de<row>\u8282\u70b9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u72b6\u6001\u3002", (String)"IndividualQueryPayImpl_3", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
            return new EBBankPayResponse(paymentInfos);
        }
        paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        request.setPaymentInfos(paymentInfos);
        PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
        for (int i = 0; i < rowList.size(); ++i) {
            Element row = (Element)rowList.get(i);
            String recAccountNo = row.getChildTextTrim("recAccountNo");
            String recAccountName = row.getChildTextTrim("recAccountName");
            String tranAmount = row.getChildTextTrim("tranAmount");
            String statusRow = row.getChildTextTrim("status");
            String statusTextRow = row.getChildTextTrim("statusText");
            PaymentInfo info = PaymentInfosUtil.selectPaymentInfo(paymentInfos, recAccountNo, recAccountName, tranAmount);
            if (null == info) continue;
            this.handlePayStatus(info, statusRow, statusTextRow);
        }
        this.processingBankItemDataHandler(rowList);
        PayStatusMatchUtil.backBatchSameItemHandler((List)paymentInfos, (boolean)false, (boolean)false);
        return new EBBankPayResponse(paymentInfos);
    }

    @Override
    public String getBankDataKey(Element row) {
        String recAccountNo = row.getChildTextTrim("recAccountNo");
        String recAccountName = row.getChildTextTrim("recAccountName");
        String tranAmount = row.getChildTextTrim("tranAmount");
        return recAccountNo + recAccountName + new BigDecimal(tranAmount).setScale(2);
    }

    @Override
    public void handlePayStatus(PaymentInfo tempInfo, Element row) {
        String statusRow = row.getChildTextTrim("status");
        String statusTextRow = row.getChildTextTrim("statusText");
        this.handlePayStatus(tempInfo, statusRow, statusTextRow);
    }

    public void handlePayStatus(PaymentInfo info, String statusRow, String statusTextRow) {
        if ("AAAAAAA".equals(statusRow)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"IndividualQueryPayImpl_4", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (String)statusRow, (String)statusTextRow);
        } else if ("CCCCCCC".equals(statusRow) || "AAAAAAB".equals(statusRow) || "AAAAAAC".equals(statusRow)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"IndividualQueryPayImpl_1", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (String)statusRow, (String)statusTextRow);
        } else if ("EEEEEEE".equals(statusRow)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"IndividualQueryPayImpl_5", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (String)statusRow, (String)statusTextRow);
        } else if ("UNKNOWN".equals(statusRow)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"IndividualQueryPayImpl_5", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (String)statusRow, (String)statusTextRow);
        } else if (StatusCodeHelper.isUnkownCode(statusRow)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"IndividualQueryPayImpl_5", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (String)statusRow, (String)statusTextRow);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"IndividualQueryPayImpl_6", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), (String)statusRow, (String)statusTextRow);
        }
    }
}

