/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.payment.salary;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.services.PayParserProxy;
import kd.ebg.aqap.banks.citic.dc.services.payment.PaymentUtils;
import kd.ebg.aqap.banks.citic.dc.services.payment.salary.SalaryQueryImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 20;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLSALIMP";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"3.3.1 \u4ee3\u53d1\u5de5\u8d44\u5bfc\u5165", (String)"SalaryImpl_3", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return this.isSalary(paymentInfo);
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = JDomUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLSALIMP");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"clientID", (String)paymentInfo.getBankBatchSeqID());
        JDomUtils.addChild((Element)root, (String)"totalNumber", (String)("" + paymentInfos.size()));
        Element totalAmountElement = JDomUtils.addChild((Element)root, (String)"totalAmount", (String)"");
        JDomUtils.addChild((Element)root, (String)"payAccountNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)root, (String)"abstract", (String)PaymentUtils.getFixedExplanation(paymentInfo.getExplanation(), 100));
        JDomUtils.addChild((Element)root, (String)"preFlg", (String)"0");
        JDomUtils.addChild((Element)root, (String)"preDate", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"preTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)root, (String)"yearMonth", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMM")));
        JDomUtils.addChild((Element)root, (String)"preparType", (String)(paymentInfo.getMerge() != false ? "1" : "0"));
        BigDecimal totalAmt = new BigDecimal("0.00");
        Element list = JDomUtils.addChild((Element)root, (String)"list");
        list.setAttribute("name", "userDataList");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            totalAmt = totalAmt.add(((PaymentInfo)paymentInfos.get(i)).getAmount());
            Element row = JDomUtils.addChild((Element)list, (String)"row");
            JDomUtils.addChild((Element)row, (String)"employeeNo", (String)Integer.toString(i + 1));
            JDomUtils.addChild((Element)row, (String)"employeeName", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            JDomUtils.addChild((Element)row, (String)"recAccountNo", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            JDomUtils.addChild((Element)row, (String)"tranAmount", (String)((PaymentInfo)paymentInfos.get(i)).getAmount().toString());
        }
        totalAmountElement.setText(totalAmt.toString());
        String message = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        return message;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PayParserProxy.parseBatchPay(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

