/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.adbc.dc.services.payment.batchPay;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayParser {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayParser.class);

    public void parseQueryPay(PaymentInfo[] paymentInfos, String rspStr) {
        if (StringUtils.isEmpty((String)rspStr)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a\u3002", (String)"QueryPayParser_0", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]));
        }
        try {
            this.parseQueryPay(rspStr, paymentInfos);
        }
        catch (EBServiceException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672c\u6b21\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u54cd\u5e94\u62a5\u6587\u6709\u8bef\u3002", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public void parseQueryPay(String rspStr, PaymentInfo[] paymentInfos) {
        this.logger.info("\u89e3\u6790\u6279\u91cf\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u62a5\u6587\u5f00\u59cb-----");
        int index = rspStr.indexOf("}\r\n");
        String body = rspStr.substring(index + 1, rspStr.length());
        String a = body.substring(body.indexOf(" xmlns="), body.indexOf("\">") + 1);
        String context = body.replace(a, "");
        try {
            Element bankData = JDomUtils.string2Root((String)context, (String)"UTF-8");
            Element payResult = bankData.getChild("PayResult");
            if (payResult == null) {
                Element rspnInfo = bankData.getChild("RspnInfo");
                String processCode = rspnInfo.getChildTextTrim("ProcessCode");
                String preResponseCode = PaymentInfoSysFiled.get((PaymentInfo)paymentInfos[0], (String)"preResponseCode");
                if (StringUtils.isNotEmpty((String)preResponseCode) && (preResponseCode.startsWith("A00") || preResponseCode.startsWith("B00")) && "S0127".equals(processCode)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)"S0127", (String)"");
                } else {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)"");
                }
            } else {
                Element totalRecord = payResult.getChild("TotalRecord");
                String totalNumber = totalRecord.getChildTextTrim("TotalNumber");
                if (Integer.parseInt(totalNumber) > 1) {
                    List paydetailsList = payResult.getChildren("Paydetails");
                    if (paydetailsList == null || paydetailsList.size() < 1) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayParser_2", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]), (String)"", (String)"");
                        return;
                    }
                    block2: for (int i = 0; i < paydetailsList.size(); ++i) {
                        Element payDetails = (Element)paydetailsList.get(i);
                        String str_bizState = payDetails.getChildTextTrim("BizState");
                        Element rspnInfo = payDetails.getChild("RspnInfo");
                        String str_processCode = rspnInfo.getChildTextTrim("ProcessCode");
                        String str_processResult = rspnInfo.getChildTextTrim("ProcessResult");
                        String str_originalListCode = payDetails.getChildTextTrim("OriginalListCode");
                        for (int j = 0; j < paymentInfos.length; ++j) {
                            String listCode = PaymentInfoSysFiled.get((PaymentInfo)paymentInfos[j], (String)"ListCode");
                            if (!listCode.equals(str_originalListCode)) continue;
                            this.logger.info("listCode-------" + listCode);
                            this.logger.info("str_bizState-------" + str_bizState);
                            if ("VR02".equals(str_bizState)) {
                                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[j], (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_3", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]), (String)str_processCode, (String)str_processResult);
                                continue block2;
                            }
                            if ("VR00".equals(str_bizState)) {
                                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[j], (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_4", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]), (String)str_processCode, (String)str_processResult);
                                continue block2;
                            }
                            if (!"VR01".equals(str_bizState)) continue block2;
                            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[j], (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayParser_5", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]), (String)str_processCode, (String)str_processResult);
                            continue block2;
                        }
                    }
                } else {
                    Element payDetails = payResult.getChild("Paydetails");
                    String str_bizState = payDetails.getChildTextTrim("BizState");
                    Element rspnInfo = payDetails.getChild("RspnInfo");
                    String str_processCode = rspnInfo.getChildTextTrim("ProcessCode");
                    String str_processResult = rspnInfo.getChildTextTrim("ProcessResult");
                    this.logger.info(str_processCode + "-------" + str_processResult);
                    if ("VR02".equals(str_bizState)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_3", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]), (String)str_processCode, (String)str_processResult);
                    } else if ("VR00".equals(str_bizState)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_4", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]), (String)str_processCode, (String)ResManager.loadKDString((String)"\u6210\u529f", (String)"QueryPayParser_6", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]));
                    } else if ("VR01".equals(str_bizState)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayParser_5", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]), (String)str_processCode, (String)str_processResult);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.info("\u6784\u9020\u5b57\u8282\u6d41\u5931\u8d25{}", (Object)e.getMessage());
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u62a5\u6587\u5931\u8d25\u3002", (String)"QueryPayParser_7", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

