/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.crbc.dc.service.balance;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.crbc.dc.service.utils.CommonUtil;
import kd.ebg.aqap.banks.crbc.dc.service.utils.Constants;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HistoryBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    EBGLogger logger = EBGLogger.getInstance().getLogger(HistoryBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        Element body = new Element("BODY");
        JDomUtils.addChild((Element)body, (String)"ACCT_NO", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"CCY", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"FROM_DATE", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"TO_DATE", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"ACC_TYPE", (String)"");
        String requestStr = CommonUtil.getPackerData(Constants.HIS_BALANCE, body);
        return requestStr;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String res) {
        Element element = CommonUtil.resSuccessCheck(res);
        Element body = element.getChild("BODY");
        Element array = body.getChild("ARRAY");
        List list = array.getChildren("STRUCT");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        for (Element struct : list) {
            BalanceInfo balanceInfo = new BalanceInfo();
            try {
                String bal_date = struct.getChildText("BAL_DATE");
                String currentBal = struct.getChildText("LEDGER_BAL");
                this.setCurrentBalance(balanceInfo, currentBal);
                LocalDateTime localDateTime = LocalDateUtil.parseDateTime((String)(bal_date + "000000"));
                this.setBalanceDateTime(balanceInfo, localDateTime);
                balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
                balanceInfo.setBankCurrency(bankBalanceRequest.getBankCurrency());
            }
            catch (Exception e) {
                balanceInfo.setError(e.getMessage());
                balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
                balanceInfo.setBankCurrency(bankBalanceRequest.getBankCurrency());
            }
            balanceInfos.add(balanceInfo);
        }
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse();
        ebBankBalanceResponse.setBalances(balanceInfos);
        return ebBankBalanceResponse;
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return Constants.HIS_BALANCE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HistoryBalanceImpl_2", (String)"ebg-aqap-banks-crbc-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/presystem/access");
    }
}

