/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.crbc.dc.service.payment.individual;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.crbc.dc.service.payment.individual.IndividualQueryPayImpl;
import kd.ebg.aqap.banks.crbc.dc.service.utils.CommonUtil;
import kd.ebg.aqap.banks.crbc.dc.service.utils.Constants;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class IndividualPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 100;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return IndividualQueryPayImpl.class;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element body = new Element("BODY");
        JDomUtils.addChild((Element)body, (String)"BATCH_NO", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"TOTAL_NUM", (String)(paymentInfos.size() + ""));
        JDomUtils.addChild((Element)body, (String)"TOTAL_AMT", (String)paymentInfo.getTotalAmount().toPlainString());
        Element array = new Element("ARRAY");
        for (PaymentInfo info : paymentInfos) {
            Element struct = new Element("STRUCT");
            JDomUtils.addChild((Element)struct, (String)"PAYERACC", (String)info.getAccNo());
            JDomUtils.addChild((Element)struct, (String)"PAYERNAME", (String)info.getAccName());
            JDomUtils.addChild((Element)struct, (String)"CURRENCY", (String)info.getCurrency());
            JDomUtils.addChild((Element)struct, (String)"PAYERACCBANK", (String)"");
            JDomUtils.addChild((Element)struct, (String)"BANK_FLAG", (String)(info.getSameBank() != false ? "0" : "1"));
            JDomUtils.addChild((Element)struct, (String)"TRANSFERTYPE", (String)"0");
            JDomUtils.addChild((Element)struct, (String)"PAYEEACC", (String)info.getIncomeAccNo());
            JDomUtils.addChild((Element)struct, (String)"PAYEENAME", (String)info.getIncomeAccName());
            JDomUtils.addChild((Element)struct, (String)"PAYEEACCBANKNAME", (String)info.getIncomeBankName());
            JDomUtils.addChild((Element)struct, (String)"PAYEEACCBANK", (String)info.getIncomeCnaps());
            JDomUtils.addChild((Element)struct, (String)"AMOUNT", (String)info.getAmount().toPlainString());
            JDomUtils.addChild((Element)struct, (String)"PAYUSE", (String)"");
            String explanation = paymentInfo.getExplanation();
            if (StringUtils.isNotEmpty((String)explanation) && explanation.length() > 100) {
                explanation = explanation.substring(0, 100);
            }
            JDomUtils.addChild((Element)struct, (String)"REMARK", (String)explanation);
            JDomUtils.addChild((Element)struct, (String)"SERIALNO", (String)info.getBankDetailSeqId());
            JDomUtils.addChild((Element)array, (Element)struct);
        }
        JDomUtils.addChild((Element)body, (Element)array);
        String requestStr = CommonUtil.getPackerData(Constants.INDIVIDUAL_PAYMENT, body);
        return requestStr;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String res) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element element = CommonUtil.resSuccessCheck(res);
        Element body = element.getChild("BODY");
        String status = body.getChildText("STATUS");
        String retMsg = body.getChildText("RETMSG");
        EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)status, (String)retMsg);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return Constants.INDIVIDUAL_PAYMENT;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u79c1\u6279\u91cf\u4ed8\u6b3e", (String)"IndividualPayImpl_0", (String)"ebg-aqap-banks-crbc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/presystem/access");
    }
}

