/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.alipay.cmp.service.payment;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayObject;
import com.alipay.api.domain.AlipayFundTransUniTransferModel;
import com.alipay.api.domain.Participant;
import com.alipay.api.request.AlipayFundTransUniTransferRequest;
import com.alipay.api.response.AlipayFundTransUniTransferResponse;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.alipay.cmp.utils.AlipayRequestUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return null;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        this.logger.info("\u652f\u4ed8\u5b9d\u63d0\u4ea4\u4ed8\u6b3e\u6d41\u7a0b\u5f00\u59cb");
        AlipayFundTransUniTransferRequest request = new AlipayFundTransUniTransferRequest();
        AlipayFundTransUniTransferResponse response = null;
        this.packerPay(info, request);
        try {
            response = (AlipayFundTransUniTransferResponse)AlipayRequestUtil.execute(request, info.getAccNo());
        }
        catch (AlipayApiException e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
        }
        if (!response.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7f51\u5173\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%1$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\uff1a%2$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%3$s", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), response.getMsg(), response.getSubCode(), response.getSubMsg()));
        }
        String status = response.getStatus();
        if ("SUCCESS".equals(status) || "DEALING".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)status, (String)status, (String)status);
        } else if ("FAIL".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)status, (String)status, (String)status);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)status, (String)status, (String)status);
        }
        this.logger.info("\u89e3\u6790\u5b8c\u6210\uff0c\u652f\u4ed8\u5b9d\u63d0\u4ea4\u4ed8\u6b3e\u6d41\u7a0b\u7ed3\u675f");
        return new EBBankPayResponse(paymentInfos);
    }

    public void packerPay(PaymentInfo info, AlipayFundTransUniTransferRequest request) {
        AlipayFundTransUniTransferModel model = new AlipayFundTransUniTransferModel();
        String out_biz_no = info.getBankDetailSeqId();
        String trans_amount = info.getAmount().setScale(2, 4).toPlainString();
        String product_code = "TRANS_ACCOUNT_NO_PWD";
        String biz_scene = "DIRECT_TRANSFER";
        String order_title = ResManager.loadKDString((String)"\u94f6\u4f01\u652f\u4ed8", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]);
        String identity = info.getIncomeAccNo();
        String identity_type = "ALIPAY_LOGON_ID";
        String name = info.getIncomeAccName();
        String remark = info.getExplanation();
        model.setOutBizNo(out_biz_no);
        model.setTransAmount(trans_amount);
        model.setProductCode(product_code);
        model.setBizScene(biz_scene);
        model.setOrderTitle(order_title);
        Participant payeeInfo = new Participant();
        payeeInfo.setIdentity(identity);
        payeeInfo.setName(name);
        payeeInfo.setIdentityType(identity_type);
        model.setPayeeInfo(payeeInfo);
        model.setRemark(remark);
        request.setBizModel((AlipayObject)model);
        this.logger.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + request.getBizContent());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

