/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.crcb.dc.detail;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.crcb.dc.helper.RequestPacker;
import kd.ebg.aqap.banks.crcb.dc.helper.ResponseParser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    private static int size = 100;

    public String getDeveloper() {
        return "Kingdee.WangJinPing";
    }

    public String getBizCode() {
        return "CL0004";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6", (String)"DetailImpl_0", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml;charset=UTF-8");
    }

    public EBBankDetailResponse detail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    private List<DetailInfo> processDetail(BankDetailRequest request) {
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        this.setCurrentPage("0");
        boolean lastPage = false;
        this.setLastPage(false);
        while (!lastPage) {
            EBBankDetailResponse response = this.doBiz(request);
            if (Objects.nonNull(response) && Objects.nonNull(response.getDetails())) {
                detailInfos.addAll(response.getDetails());
            }
            this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 1);
            lastPage = this.isLastPage();
        }
        return detailInfos;
    }

    public String pack(BankDetailRequest rqst) {
        return RequestPacker.getDetailsMessage(rqst, Integer.parseInt(this.getCurrentPage()), size);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        List<DetailInfo> detailInfos = ResponseParser.parserDeatilsMessage(bankDetailRequest, s);
        if (detailInfos.size() == 0 || detailInfos.size() < size) {
            this.setLastPage(true);
        }
        return new EBBankDetailResponse(detailInfos);
    }
}

